/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.utils;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FieldsQueryParam {
    private JsonArray properties = null;
    private JsonArray refProps = null;
    private final String delimsField = ",{}";
    private final String delimsPropertyRegex = "\\.";
    private final String delimsProperty = ".";
    private final String errorMsg = "Invalid syntax for parameter fields.";

    public FieldsQueryParam(String queryString) throws ContentException {
        this(queryString, null);
    }

    public FieldsQueryParam(String queryString, String defaults, boolean includeDefaults) throws ContentException {
        if (queryString == null || queryString.isEmpty()) {
            if (defaults == null) {
                defaults = "defaultName";
            }
            queryString = defaults;
        } else if (includeDefaults && defaults != null && !defaults.isEmpty()) {
            queryString = queryString + "," + defaults;
        }
        queryString = queryString + ",modificationTime,version,id";
        this.properties = new JsonArray();
        this.parse(queryString);
    }

    public FieldsQueryParam(String queryString, String defaults) throws ContentException {
        this(queryString, defaults, false);
    }

    public JsonArray getProperties() {
        return this.properties;
    }

    public JsonArray getRefProps() {
        return this.refProps;
    }

    private void parse(String params) {
        Map<String, JsonArray> paramsMap = this.parseParams(params);
        if (paramsMap.containsKey("path")) {
            paramsMap.put("searchPath", new JsonArray());
            paramsMap.remove("path");
        }
        this.translateMapToCmQueryOptions(paramsMap);
    }

    private void translateMapToCmQueryOptions(Map<String, JsonArray> paramsMap) {
        for (String key : paramsMap.keySet()) {
            this.properties.add((Object)key);
            if (paramsMap.get(key).isEmpty()) continue;
            if (this.refProps == null) {
                this.refProps = new JsonArray();
            }
            JsonObject newRefProp = new JsonObject();
            newRefProp.put("refPropName", (Object)key);
            newRefProp.put("properties", (Object)paramsMap.get(key));
            this.refProps.add((Object)newRefProp);
        }
    }

    private Map<String, JsonArray> parseParams(String params) {
        HashMap<String, JsonArray> paramsMap = new HashMap<String, JsonArray>();
        StringTokenizer st = new StringTokenizer(params, ",{}", true);
        String possibleTokenBeforeOpeningBracket = "";
        int bracketCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contentEquals(",")) continue;
            if (token.contentEquals("{")) {
                if (bracketCounter > 0) {
                    throw new ContentException("Invalid syntax for parameter fields.");
                }
                ++bracketCounter;
                continue;
            }
            if (token.contentEquals("}")) {
                if (bracketCounter == 0) {
                    throw new ContentException("Invalid syntax for parameter fields.");
                }
                --bracketCounter;
                continue;
            }
            String[] propArray = token.split("\\.");
            if (propArray.length == 2) {
                if (bracketCounter > 0 || propArray[0].isEmpty() || propArray[1].isEmpty()) {
                    throw new ContentException("Invalid syntax for parameter fields.");
                }
                if (!paramsMap.containsKey(propArray[0])) {
                    paramsMap.put(propArray[0], new JsonArray());
                }
                ((JsonArray)paramsMap.get(propArray[0])).add((Object)propArray[1]);
                continue;
            }
            if (propArray.length == 1) {
                if (token.contains(".")) {
                    throw new ContentException("Invalid syntax for parameter fields.");
                }
                if (bracketCounter > 0) {
                    ((JsonArray)paramsMap.get(possibleTokenBeforeOpeningBracket)).add((Object)propArray[0]);
                    continue;
                }
                possibleTokenBeforeOpeningBracket = token;
                if (paramsMap.containsKey(propArray[0])) continue;
                paramsMap.put(propArray[0], new JsonArray());
                continue;
            }
            throw new ContentException("Invalid syntax for parameter fields.");
        }
        if (bracketCounter > 0) {
            throw new ContentException("Invalid syntax for parameter fields.");
        }
        return paramsMap;
    }
}

