/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.utils;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class PathBuilder {
    private static final HashMap<String, String> aliases = new HashMap();
    StringBuilder buf = new StringBuilder();
    private static DynamicStringProperty permissionsFilter;

    public static String fromId(String id) {
        return new PathBuilder().id(id).toString();
    }

    public PathBuilder id(String id) {
        if (id.charAt(0) == '.') {
            String alias = aliases.get(id);
            if (alias == null) {
                throw new RestException(400, new ContentMessage(MessageKeys.INVALID_OBJECT_ID, id));
            }
            this.buf.append(alias);
        } else {
            this.buf.append("storeID(\"").append(id).append("\")");
        }
        return this;
    }

    public PathBuilder defaultOutput(String id) {
        this.buf.append("defaultOutput(storeID(\"").append(id).append("\"))");
        return this;
    }

    public PathBuilder children(String ... types) {
        this.buf.append('/');
        return this.classFilter(types);
    }

    public PathBuilder descendants(String ... types) {
        this.buf.append("/descendant::");
        return this.classFilter(types);
    }

    private PathBuilder classFilter(String ... types) {
        if (types == null || types.length == 0) {
            this.buf.append("*");
        } else if (types.length == 1) {
            this.buf.append(types[0]);
        } else {
            this.buf.append("*");
            this.oneOf("@objectClass", types);
        }
        return this;
    }

    public PathBuilder name(String name) {
        return this.equals("@name", name);
    }

    public PathBuilder last() {
        this.buf.append("[last()]");
        return this;
    }

    public PathBuilder equals(String property, String value) {
        this.buf.append('[').append(property).append('=');
        this.quote(value);
        this.buf.append(']');
        return this;
    }

    public PathBuilder isNotNull(String prop) {
        this.buf.append("[not(isNull('").append(prop).append("'))]");
        return this;
    }

    public PathBuilder isNull(String prop) {
        this.buf.append("[isNull('").append(prop).append("')]");
        return this;
    }

    public PathBuilder oneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append('=');
            this.quote(value);
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder noneOf(String property, String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String value : values) {
            this.buf.append(sep).append(property).append("!=");
            this.quote(value);
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder anyPermission(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " or ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder allPermissions(String ... values) {
        this.buf.append('[');
        String sep = "";
        for (String permission : values) {
            this.buf.append(sep).append("permission('").append(permission).append("')");
            sep = " and ";
        }
        this.buf.append(']');
        return this;
    }

    public PathBuilder navigationFilter() {
        this.buf.append("[@shown='true']");
        String[] permissions = this.getPermissionsFilter();
        this.anyPermission(permissions);
        return this;
    }

    private synchronized String[] getPermissionsFilter() {
        String permissionsFilterStr = StringUtils.isEmpty((String)permissionsFilter.getValue()) ? (String)permissionsFilter.getDefaultValue() : permissionsFilter.getValue();
        String[] permissions = permissionsFilterStr.trim().split("\\s*,\\s*");
        return permissions;
    }

    public String toString() {
        return this.buf.toString();
    }

    private void quote(String value) {
        int n = value.indexOf(34);
        if (n == -1) {
            this.buf.append('\"').append(value).append('\"');
        } else if (value.indexOf(39) == -1) {
            this.buf.append('\'').append(value).append('\'');
        } else {
            this.buf.append('\"');
            int start = 0;
            while (n != -1) {
                this.buf.append(value.substring(start, n)).append('\"');
                start = n + 1;
                n = value.indexOf(34, start);
            }
            this.buf.append(value.substring(start)).append('\"');
        }
    }

    static {
        aliases.put(".public_folders", "/content");
        aliases.put(".my_folders", "~/folder");
        aliases.put(".public", "/content");
        aliases.put(".personal", "~/folder");
        aliases.put(".library", "/catalog");
        permissionsFilter = ConfigurationPropertyFactory.getInstance().getStringProperty("Content_Service.permissionsFilter", "read,write,execute,traverse,setPolicy");
    }
}

