/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.utils;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyBuilder.class);
    private static final JsonObject permissionsMap = PolicyBuilder.parseJson("{r: {name:read, access:grant},w: {name:write, access:grant},x: {name:execute, access:grant},t: {name:traverse, access:grant},p: {name:setPolicy, access:grant},R: {name:read, access:deny},W: {name:write, access:deny},X: {name:execute, access:deny},T: {name:traverse, access:deny},P: {name:setPolicy, access:deny}}");
    private JsonArray policies = new JsonArray();

    private static JsonObject parseJson(String s) {
        try {
            return JsonObject.parseString((String)s, (boolean)false);
        }
        catch (IOException e) {
            LOG.error("failed to parse permissionsMap", (Throwable)e);
            return null;
        }
    }

    public PolicyBuilder addPolicy(String searchPath, String permissionChars) {
        JsonObject policy = new JsonObject();
        policy.put("type", (Object)"policy");
        policy.put("securityObject", (Object)this.makeSecurityObject(searchPath));
        policy.put("permissions", (Object)this.makePermissions(permissionChars));
        this.policies.add((Object)policy);
        return this;
    }

    private JsonObject makeSecurityObject(String searchPath) {
        JsonObject securityObj = new JsonObject();
        securityObj.put("type", (Object)"baseClass");
        securityObj.put("searchPath", (Object)searchPath);
        return securityObj;
    }

    private JsonArray makePermissions(String permissionChars) {
        JsonArray permissions = new JsonArray();
        for (char c : permissionChars.toCharArray()) {
            permissions.add(permissionsMap.get(String.valueOf(c)));
        }
        return permissions;
    }

    public JsonArray build() {
        return this.policies;
    }
}

