/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class JsonObjectHelper {
    @ApiModelProperty(hidden=true)
    private final JsonObject json;
    private Set<String> allowedPropertyNames = new HashSet<String>();

    public JsonObjectHelper(JsonObject json) {
        this.json = json;
    }

    public JsonObject getJson() {
        return this.json;
    }

    public static JsonObjectHelper copyFrom(JsonObject json) {
        try {
            return new JsonObjectHelper(JsonObject.parseString((String)json.toString(), (boolean)true));
        }
        catch (IOException e) {
            throw new ContentException("unexpected problem duplicating Json object", (Throwable)e);
        }
    }

    public void renameProperty(String fromName, String toName) {
        if (this.json.containsKey((Object)fromName)) {
            this.json.put(toName, this.json.remove((Object)fromName));
        }
    }

    public void stringizeProperty(String propName) {
        Object o = this.json.get(propName);
        if (o == null) {
            return;
        }
        if (!(o instanceof JsonObject)) {
            throw new ContentException(Response.Status.BAD_REQUEST, "value of " + propName + " must be a JsonObject");
        }
        this.json.put(propName, (Object)o.toString());
    }

    public void jsonizeProperty(String propName) {
        String j = this.json.getString(propName);
        if (StringUtils.isEmpty((String)j)) {
            return;
        }
        try {
            JsonObject o = JsonObject.parseString((String)j, (boolean)true);
            if (!(o instanceof JsonObject)) {
                throw new ContentException("generic doc content is not valid Json: " + o.getClass().getSimpleName());
            }
            this.json.put(propName, (Object)o);
        }
        catch (IOException e) {
            throw new ContentException("generic doc content is not valid Json", (Throwable)e);
        }
    }

    public boolean removeFromArray(String arrayPropertyName, String value) {
        int idx;
        JsonArray array = this.json.getArray(arrayPropertyName);
        if (array == null) {
            return false;
        }
        boolean found = false;
        while ((idx = array.indexOf((Object)value)) != -1) {
            found = true;
            array.remove(idx);
        }
        return found;
    }

    protected void addRecognizedPropertyNames(String ... names) {
        for (String name : names) {
            this.allowedPropertyNames.add(name);
        }
    }

    protected boolean isRecognizedProperty(String propertyName) {
        return this.allowedPropertyNames.contains(propertyName);
    }

    public void removeUnrecognizedProperties() {
        Set keys = this.getJson().keySet();
        Iterator keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            if (this.isRecognizedProperty(key)) continue;
            keyIterator.remove();
        }
    }
}

