/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.home;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.content.appres.home.Identity;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.restful.ContentManager;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMIdentity
implements Identity {
    private final Logger LOG = LoggerFactory.getLogger(CMIdentity.class);
    private JsonObject sessionJson;
    private final ContentManager cm;
    private String accountStoreID;

    @Inject
    public CMIdentity(ContentManager cm) {
        this.cm = cm;
    }

    private void initialize() {
        if (this.sessionJson == null) {
            this.sessionJson = this.querySession();
            this.accountStoreID = this.extractCAMID();
        }
    }

    private JsonObject querySession() {
        try {
            JsonObject res = this.cm.query("~~", new JsonArray(new Object[]{"identity", "userCapabilities"}), null, true);
            return res.getArray("objects").getObject(0);
        }
        catch (Exception e) {
            this.LOG.debug("failed to get user identity", (Throwable)e);
            throw new ContentException("failed to query session", (Throwable)e);
        }
    }

    @Override
    public String getAccountID() {
        this.initialize();
        return this.accountStoreID;
    }

    @Override
    public boolean userHasCapability(String capability) {
        this.initialize();
        JsonArray userCapabilities = this.sessionJson.getArray("userCapabilities");
        return userCapabilities != null && userCapabilities.contains((Object)capability);
    }

    @Override
    public boolean contains(String storeID) {
        this.initialize();
        JsonArray identities = this.sessionJson.getArray("identity");
        for (JsonObject ident : identities.items(JsonObject.class)) {
            if (!StringUtils.equals((String)storeID, (String)ident.getString("id"))) continue;
            return true;
        }
        return false;
    }

    private String extractCAMID() {
        String accountId = this.findAccountID(this.sessionJson.getArray("identity"));
        if (accountId == null) {
            throw new ContentException("failed to extract user identity");
        }
        return accountId;
    }

    private String findAccountID(JsonArray identities) {
        if (identities != null) {
            for (JsonObject ident : identities.items(JsonObject.class)) {
                if (!"account".equals(ident.getString("type"))) continue;
                return ident.getString("id");
            }
        }
        return null;
    }
}

