/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.home;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.appres.Trusted;
import com.ibm.bi.content.appres.home.CAMIDDigester;
import com.ibm.bi.content.appres.home.IHomeFolder;
import com.ibm.bi.content.appres.home.Identity;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.restful.ContentManager;
import dagger.Lazy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeFolder
implements IHomeFolder {
    private static final Logger LOG = LoggerFactory.getLogger(HomeFolder.class);
    private static String homeStoreID;
    private final Identity identity;
    private final Lazy<ContentManager> restCM;
    private final Lazy<ContentManager> trustedRestCM;
    private String userHomedirName;
    private String userHomeStoreID;

    @Inject
    public HomeFolder(Identity identity, Lazy<ContentManager> restCM, @Trusted Lazy<ContentManager> trustedRestCM) {
        this.identity = identity;
        this.restCM = restCM;
        this.trustedRestCM = trustedRestCM;
    }

    private String getUserHomedirName() throws Exception {
        if (this.userHomedirName == null) {
            this.userHomedirName = new CAMIDDigester().digest(this.identity.getAccountID());
        }
        return this.userHomedirName;
    }

    @Override
    public String ensureUserHomeSubFolder(String subfolderName) throws Exception {
        String storeID;
        try {
            String path = new PathBuilder().id(this.findHome()).children(new String[]{"folder"}).name(this.getUserHomedirName()).children(new String[]{"folder"}).name(subfolderName).toString();
            JsonObject response = ((ContentManager)this.restCM.get()).query(path, this.makeProps(), null, false);
            storeID = !this.isEmptyCMResponse(response) ? this.extractStoreID(response) : this.makeHomeSubfolder(this.getUserHomedirName(), subfolderName);
        }
        catch (Exception e) {
            LOG.error("failed to create user folder", (Throwable)e);
            throw new RestException(500, new ContentMessage(MessageKeys.INTERNAL_ERROR), (Throwable)new ContentException(String.format("failed to create user's %s folder", subfolderName), (Throwable)e));
        }
        return storeID;
    }

    @Override
    public String findUserHomeSubFolder(String subfolderName) throws Exception {
        String userHomeStoreID = this.findUserHome();
        if (userHomeStoreID == null) {
            return null;
        }
        return this.findFolder(userHomeStoreID, subfolderName);
    }

    private String makeHomeSubfolder(String hashedcamid, String subFolderName) throws Exception {
        String userHomeID = this.ensureSubFolder(this.findHome(), hashedcamid, (ContentManager)this.trustedRestCM.get());
        return this.ensureSubFolder(userHomeID, subFolderName, (ContentManager)this.restCM.get());
    }

    private String findHome() throws Exception {
        if (homeStoreID == null) {
            homeStoreID = this.findFolder(null, "home");
        }
        return homeStoreID;
    }

    private String findUserHome() throws Exception {
        if (this.userHomeStoreID == null) {
            this.userHomeStoreID = this.findFolder(this.findHome(), this.getUserHomedirName());
        }
        return this.userHomeStoreID;
    }

    private String findFolder(String parentStoreID, String folderName) throws Exception {
        String path = parentStoreID == null ? new PathBuilder().children(new String[]{"folder"}).name(folderName).toString() : new PathBuilder().id(parentStoreID).children(new String[]{"folder"}).name(folderName).toString();
        JsonObject res = ((ContentManager)this.restCM.get()).query(path, this.makeProps(), null, true);
        if (!this.isEmptyCMResponse(res)) {
            return this.extractStoreID(res);
        }
        return null;
    }

    private String ensureSubFolder(String parentStoreID, String folderName, ContentManager cm) throws Exception {
        String storeID = this.findFolder(parentStoreID, folderName);
        if (storeID != null) {
            return storeID;
        }
        String path = PathBuilder.fromId((String)parentStoreID);
        JsonArray folders = cm.add(path, new JsonArray(new Object[]{this.makeFolderObject(folderName)}), "update");
        return folders.getObject(0).getString("id");
    }

    private String extractStoreID(JsonObject cmresult) {
        return cmresult.getArray("objects").getObject(0).getString("id");
    }

    private boolean isEmptyCMResponse(JsonObject res) {
        if (res == null) {
            return true;
        }
        JsonArray objects = res.getArray("objects");
        return objects == null || objects.size() == 0;
    }

    private JsonArray makeProps() {
        return new JsonArray(new Object[]{"defaultName", "storeID"});
    }

    private JsonObject makeFolderObject(String name) {
        JsonObject jo = new JsonObject();
        jo.put("type", (Object)"folder");
        jo.put("defaultName", (Object)name);
        return jo;
    }
}

