/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.content.appres.palettes.DocTypeInfo;
import com.ibm.bi.content.appres.palettes.GenericDocSearcher;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import dagger.Lazy;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Inject;

public class CaRestGenDocSearcher
implements GenericDocSearcher {
    private final Lazy<RESTClient> restClient;
    private final DocTypeInfo docTypeInfo;

    @Inject
    public CaRestGenDocSearcher(Lazy<RESTClient> restClient, DocTypeInfo docTypeInfo) {
        this.restClient = restClient;
        this.docTypeInfo = docTypeInfo;
    }

    @Override
    public JsonArray listPublic() throws Exception {
        JsonObject srchResponse = ((RESTClient)this.restClient.get()).getResource(this.makePublicQuery(this.docTypeInfo.getTypeName()), "application/json");
        return srchResponse.getArray("results");
    }

    @Override
    public JsonArray findReferencesTo(String documentID) throws Exception {
        JsonObject srchResponse = ((RESTClient)this.restClient.get()).getResource(this.makeReferencesQuery(documentID), "application/json");
        return srchResponse.getArray("results");
    }

    private String urlEncodeQuietly(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ContentException("unexpected exception", (Throwable)e);
        }
    }

    private String makePublicQuery(String docType) {
        return "/bi/v1/search/cm?fields=" + this.urlEncodeQuietly("type,id,defaultName,documentID,documentType,tags") + "&results=2000&filter=" + this.urlEncodeQuietly("type|genericDocument") + "&filter=" + this.urlEncodeQuietly("tags|__public_true__") + "&filter=" + this.urlEncodeQuietly("documentType|" + docType);
    }

    private String makeReferencesQuery(String documentID) {
        return "/bi/v1/search/cm?fields=" + this.urlEncodeQuietly("type,id,searchPath,defaultName") + "&results=100&filter=" + this.urlEncodeQuietly("references|" + documentID);
    }
}

