/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.content.appres.palettes.GenericDocStore;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.ContentManager;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmGenericDocStore
implements GenericDocStore {
    private final Logger LOG = LoggerFactory.getLogger(CmGenericDocStore.class);
    private static final JsonArray PROPS_FOR_GET;
    private static final JsonArray PROPS_FOR_LIST;
    private final Lazy<ContentManager> soapCM;
    private final Lazy<com.ibm.bi.soap.restful.ContentManager> restCM;

    @Inject
    public CmGenericDocStore(Lazy<ContentManager> soapCM, Lazy<com.ibm.bi.soap.restful.ContentManager> restCM) {
        this.soapCM = soapCM;
        this.restCM = restCM;
    }

    @Override
    public JsonArray listGenDocs(String folderStoreID) throws Exception {
        String path = String.format("storeID(\"%s\")/*", folderStoreID);
        JsonObject res = ((com.ibm.bi.soap.restful.ContentManager)this.restCM.get()).query(path, PROPS_FOR_LIST, null, false);
        this.LOG.debug("palette list response: " + res.toString());
        return res.getArray("objects");
    }

    @Override
    public JsonArray getGenDoc(String docID) throws Exception {
        JsonObject jo = ((com.ibm.bi.soap.restful.ContentManager)this.restCM.get()).query(this.searchPathForDocID(docID), PROPS_FOR_GET, null, true);
        return jo.getArray("objects");
    }

    @Override
    public JsonArray getGenDocList(List<String> documentids) throws Exception {
        ContentManager cm = (ContentManager)this.soapCM.get();
        ArrayList<Map> queries = new ArrayList<Map>();
        for (String docID : documentids) {
            queries.add(cm.queryRequest(this.searchPathForDocID(docID), (List)PROPS_FOR_GET, null, null));
        }
        List queryResults = cm.queryMultiple(queries);
        JsonArray result = new JsonArray();
        for (Object obj : queryResults) {
            JsonObject queryResult = (JsonObject)obj;
            JsonArray resultArray = queryResult.getArray("queryResult");
            if (resultArray.isEmpty()) continue;
            result.add((Object)resultArray.getObject(0));
        }
        return result;
    }

    @Override
    public void deleteGenDoc(String docID) throws Exception {
        ((com.ibm.bi.soap.restful.ContentManager)this.restCM.get()).delete(this.searchPathForDocID(docID), true, true);
    }

    @Override
    public void updateGenDoc(JsonObject updateJson) throws Exception {
        String docid = (String)updateJson.remove((Object)"documentID");
        updateJson.put("searchPath", (Object)this.searchPathForDocID(docid));
        ((com.ibm.bi.soap.restful.ContentManager)this.restCM.get()).update(new JsonArray(new Object[]{updateJson}));
    }

    @Override
    public void createGenDoc(String folderStoreID, JsonObject json) throws Exception {
        ((com.ibm.bi.soap.restful.ContentManager)this.restCM.get()).add(PathBuilder.fromId((String)folderStoreID), new JsonArray(new Object[]{json}), "fail");
    }

    private String searchPathForDocID(String documentID) {
        return String.format("//genericDocument[@documentID=\"%s\"]", documentID);
    }

    static {
        PROPS_FOR_LIST = new JsonArray(new Object[]{"storeID", "screenTip", "defaultScreenTip", "documentID", "documentType", "tags", "content", "owner"});
        PROPS_FOR_GET = new JsonArray(new Object[]{"creationTime", "modificationTime", "version"});
        PROPS_FOR_GET.addAll((Collection)PROPS_FOR_LIST);
    }
}

