/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.appres.home.IHomeFolder;
import com.ibm.bi.content.appres.home.Identity;
import com.ibm.bi.content.appres.palettes.DocTypeInfo;
import com.ibm.bi.content.appres.palettes.GenericDocSearcher;
import com.ibm.bi.content.appres.palettes.GenericDocStore;
import com.ibm.bi.content.appres.palettes.Palette;
import com.ibm.bi.content.appres.palettes.PaletteRepository;
import com.ibm.bi.content.appres.palettes.PaletteStorageAdapter;
import com.ibm.bi.content.appres.palettes.ReferencesPreventDeleteException;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmPaletteRepository
implements PaletteRepository {
    private final Logger LOG = LoggerFactory.getLogger(CmPaletteRepository.class);
    private static final String MAKE_PALETTE_PUBLIC_CAPABILITY = "canUsePortalAdministrationTool";
    private final IHomeFolder homeFolder;
    private final GenericDocStore genericDocStore;
    private final GenericDocSearcher genDocSearcher;
    private final Identity identity;
    private final DocTypeInfo docTypeInfo;
    private PaletteStorageAdapter storageAdapter;

    @Inject
    public CmPaletteRepository(IHomeFolder homeFolder, GenericDocStore genericDocStore, GenericDocSearcher genDocSearcher, Identity identity, PaletteStorageAdapter storageAdapter, DocTypeInfo docTypeInfo) {
        this.homeFolder = homeFolder;
        this.genericDocStore = genericDocStore;
        this.genDocSearcher = genDocSearcher;
        this.identity = identity;
        this.storageAdapter = storageAdapter;
        this.docTypeInfo = docTypeInfo;
    }

    @Override
    public List<Palette> listPersonal() throws Exception {
        JsonArray ja = this.listContents(this.homeFolder);
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        for (JsonObject jo : ja.items(JsonObject.class)) {
            Palette pal = new Palette(this.storageAdapter.fromStorageJson(jo));
            if (!pal.isValid()) {
                this.LOG.debug("skip invalid personal palette {}", (Object)pal);
                continue;
            }
            palettes.add(pal);
        }
        return palettes;
    }

    private JsonArray listContents(IHomeFolder homer) throws Exception {
        String collectionName = this.docTypeInfo.getCollectionName();
        try {
            String paletteFldrStoreID = homer.findUserHomeSubFolder(collectionName);
            if (StringUtils.isEmpty((String)paletteFldrStoreID)) {
                return new JsonArray();
            }
            return this.genericDocStore.listGenDocs(paletteFldrStoreID);
        }
        catch (Exception e) {
            throw new ContentException("failed to list contents of user's " + collectionName + " folder", (Throwable)e);
        }
    }

    @Override
    public Palette getPalette(String documentid) throws Exception {
        JsonArray result = this.genericDocStore.getGenDoc(documentid);
        if (result.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Palette pal = new Palette(this.storageAdapter.fromStorageJson(result.getObject(0)));
        if (!pal.isValid()) {
            this.LOG.warn("palette with id {} is malformed", (Object)documentid);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return pal;
    }

    @Override
    public void deletePalette(String documentID, boolean forced) throws Exception {
        JsonArray referers;
        if (!forced && (referers = this.findReferencesTo(documentID)) != null && referers.size() > 0) {
            throw new ReferencesPreventDeleteException(referers);
        }
        this.genericDocStore.deleteGenDoc(documentID);
    }

    @Override
    public String create(Palette palette) throws Exception {
        this.validate(palette);
        String palettesFolderStoreID = this.homeFolder.ensureUserHomeSubFolder(this.docTypeInfo.getCollectionName());
        String docID = palette.ensureDocumentId();
        JsonObject storageJson = this.storageAdapter.toStorageJson(palette.getJson());
        this.genericDocStore.createGenDoc(palettesFolderStoreID, storageJson);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("created new palette with documentID {}", (Object)docID);
        }
        return docID;
    }

    @Override
    public void update(Palette incoming) {
        try {
            this.validate(incoming);
            String docID = incoming.getDocumentId();
            Palette current = this.getPalette(docID);
            if (incoming.publicIsSet()) {
                incoming.copyTagsNoClobber(current);
            }
            this.genericDocStore.updateGenDoc(this.storageAdapter.toStorageJson(incoming.getJson()));
        }
        catch (WebApplicationException wax) {
            throw wax;
        }
        catch (ContentException rsx) {
            throw rsx;
        }
        catch (Exception e) {
            this.LOG.error("error updating palette", (Throwable)e);
            throw new ContentException("error querying for list of public palettes", (Throwable)e);
        }
    }

    @Override
    public List<Palette> listPublic() {
        try {
            ArrayList<Palette> palettes = new ArrayList<Palette>();
            JsonArray publiks = this.genDocSearcher.listPublic();
            if (publiks.isEmpty()) {
                return palettes;
            }
            ArrayList<String> publikIDs = new ArrayList<String>();
            for (JsonObject jo : publiks.items(JsonObject.class)) {
                publikIDs.add(jo.getString("documentID"));
            }
            JsonArray ja = this.genericDocStore.getGenDocList(publikIDs);
            for (JsonObject jo : ja.items(JsonObject.class)) {
                Palette pal = new Palette(this.storageAdapter.fromStorageJson(jo));
                if (!pal.isValid()) {
                    this.LOG.debug("skipping invalid public palette {}", (Object)jo);
                    continue;
                }
                palettes.add(pal);
            }
            return palettes;
        }
        catch (Exception e) {
            this.LOG.error("error listing public palettes", (Throwable)e);
            throw new ContentException("error querying for list of public palettes", (Throwable)e);
        }
    }

    private JsonArray findReferencesTo(String documentID) {
        try {
            return this.genDocSearcher.findReferencesTo(documentID);
        }
        catch (Exception e) {
            this.LOG.error("error searching for references to palette", (Throwable)e);
            throw new ContentException("error searching for references to palette " + documentID, (Throwable)e);
        }
    }

    private void validate(Palette palette) {
        if (palette.publicIsSet() && !this.isAuthorizedToMakePublic()) {
            throw new RestException(Response.Status.BAD_REQUEST.getStatusCode(), new ContentMessage(MessageKeys.NOTAUTHORIZED), (Throwable)new ContentException("user does not have capability to change public visibility"));
        }
    }

    private boolean isAuthorizedToMakePublic() {
        return this.identity.userHasCapability(MAKE_PALETTE_PUBLIC_CAPABILITY);
    }
}

