/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import org.apache.commons.lang.StringUtils;

public class DocTypeInfo {
    static final String DOCTYPE_PREFIX = "ibm.bi.cm.genericDocument.";
    private final String folderName;
    private final String typeName;

    DocTypeInfo(String foldername, String typename) {
        this.folderName = foldername;
        this.typeName = typename;
    }

    public String getCollectionName() {
        return this.folderName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static DocTypeInfo make(String collectionName) {
        return new DocTypeInfo(collectionName.toLowerCase(), DocTypeInfo.mimeTypeForCollectionName(collectionName));
    }

    public static String collectionNameForMimeType(String mimeType) {
        if (StringUtils.isEmpty((String)mimeType) || !mimeType.startsWith(DOCTYPE_PREFIX)) {
            return "unknown";
        }
        return mimeType.substring(DOCTYPE_PREFIX.length()) + "s";
    }

    public static String mimeTypeForCollectionName(String collectionName) {
        String genDocTypeName = collectionName.substring(0, collectionName.length() - 1).toLowerCase();
        return DOCTYPE_PREFIX + genDocTypeName;
    }
}

