/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.content.appres.JsonObjectHelper;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class Palette
extends JsonObjectHelper {
    public static final String PN_DEF_NAME = "defaultName";
    public static final String PN_NAME = "name";
    public static final String PN_ID = "id";
    public static final String PN_TAGS = "tags";
    public static final String PN_CONTENT = "content";
    public static final String PN_PUBLIC = "public";
    public static final String PN_TYPE = "type";
    public static final String PN_ISMINE = "isMine";
    private static final String[] REQUIRED_PROPS = new String[]{"id", "type"};
    public static final String PUBLIC_TAG = "__public_true__";

    public Palette(JsonObject json) {
        super(json);
        this.addRecognizedPropertyNames(PN_DEF_NAME, PN_NAME, PN_TAGS, PN_CONTENT, PN_PUBLIC, PN_ID);
    }

    public boolean publicIsSet() {
        return this.getJson().containsKey((Object)PN_PUBLIC);
    }

    public boolean isPublic() {
        Boolean publik = this.getJson().getBoolean(PN_PUBLIC);
        return publik != null ? publik : false;
    }

    public String getID() {
        return this.getJson().getString(PN_ID);
    }

    public boolean tagsAreSet() {
        return this.getJson().containsKey((Object)PN_TAGS);
    }

    public void setTags(Collection<String> tags) {
        this.getJson().put(PN_TAGS, (Object)(tags == null ? null : new JsonArray(tags)));
    }

    @ApiModelProperty(dataType="[Ljava.lang.String;")
    public List<String> getTags() {
        JsonArray tags = this.getJson().getArray(PN_TAGS);
        return tags == null ? null : new ArrayList(this.getJson().getArray(PN_TAGS).items(String.class));
    }

    public void copyTagsNoClobber(Palette other) {
        if (this.tagsAreSet()) {
            return;
        }
        if (other.tagsAreSet()) {
            this.setTags(other.getTags());
        }
    }

    public String ensureDocumentId() {
        String documentid = this.getJson().getString(PN_ID);
        if (StringUtils.isEmpty((String)documentid)) {
            documentid = UUID.randomUUID().toString().replace("-", "");
            this.getJson().put(PN_ID, (Object)documentid);
        }
        return documentid;
    }

    public String getDocumentId() {
        return this.getJson().getString(PN_ID);
    }

    public boolean setDocumentIdNoClobber(String documentId) {
        if (StringUtils.isEmpty((String)this.getDocumentId())) {
            this.setDocumentId(documentId);
            return true;
        }
        return StringUtils.equals((String)this.getDocumentId(), (String)documentId);
    }

    public void setDocumentId(String documentId) {
        this.getJson().put(PN_ID, (Object)documentId);
    }

    public String getDefaultName() {
        return this.getJson().getString(PN_DEF_NAME);
    }

    public JsonObject getContent() {
        return this.getJson().getObject(PN_CONTENT);
    }

    public boolean isValid() {
        for (String prop : REQUIRED_PROPS) {
            if (!StringUtils.isEmpty((String)this.getJson().getString(prop))) continue;
            return false;
        }
        return true;
    }
}

