/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.content.appres.BaseOperationsResource;
import com.ibm.bi.content.appres.palettes.DocTypeInfo;
import com.ibm.bi.content.appres.palettes.Palette;
import com.ibm.bi.content.appres.palettes.PaletteResourceImpl;
import com.ibm.bi.content.appres.palettes.inject.DaggerPaletteResourceComponent;
import com.ibm.bi.content.appres.palettes.inject.PaletteResourceComponent;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{collectionName:(palettes|custom_styles)}")
@Api(value="palettes|custom_styles", description="Operations on collections of color palette or customStyle generic documents")
public class PaletteResource
extends BaseOperationsResource {
    private static final Logger LOG = LoggerFactory.getLogger(PaletteResource.class);
    private static final String TRUSTED_SVC_NAME = "CONTENT-SERVICE";

    @GET
    @Path(value="/my")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns list of all my generic docs in the specified collection")
    public Response listMyPalettes(@PathParam(value="collectionName") String collectionName) throws Exception {
        return this.getImplementation(collectionName).listMyPalettes().build();
    }

    @GET
    @Path(value="/public")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns list of all public generic docs from the specified collection type")
    public Response listPublicPalettes(@PathParam(value="collectionName") String collectionName) throws Exception {
        return this.getImplementation(collectionName).listPublicPalettes().build();
    }

    @GET
    @Path(value="/{documentId:.*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="get a generic doc by id")
    public Response getPalette(@PathParam(value="collectionName") String collectionName, @PathParam(value="documentId") String documentId) throws Exception {
        return this.getImplementation(collectionName).getPalette(documentId).build();
    }

    @POST
    @Path(value="/my")
    @Consumes(value={"application/json"})
    @ApiOperation(value="create new personal generic doc in the specified collection")
    public Response createMyPalette(@PathParam(value="collectionName") String collectionName, @ApiParam(value="Palette definition.<p> name is required, the rest is optional.") Palette palette) throws Exception {
        return this.getImplementation(collectionName).createMyPalette(this.buildBaseURL(), palette).build();
    }

    @DELETE
    @Path(value="/{documentId:.*}")
    @ApiOperation(value="delete a generic doc by id")
    public Response deletePalette(@PathParam(value="collectionName") String collectionName, @PathParam(value="documentId") String documentId, @ApiParam(value="force deletion even if the palette is referenced", required=false) @QueryParam(value="forced") boolean forced) throws Exception {
        return this.getImplementation(collectionName).deletePalette(documentId, forced).build();
    }

    @PUT
    @Path(value="/{documentId:.*}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="update a generic doc")
    public Response updatePalette(@PathParam(value="collectionName") String collectionName, @PathParam(value="documentId") String documentId, @ApiParam(value="document content.<p> all properties are optional.  Those provided are merged in.") Palette palette) throws Exception {
        return this.getImplementation(collectionName).updatePalette(documentId, palette).build();
    }

    PaletteResourceImpl getImplementation(String collectionName) {
        PaletteResourceComponent comp = DaggerPaletteResourceComponent.builder().biBusSupplier(this.getBiBusSupplier()).trustedBiBusSupplier(this.getTrustedBiBusSupplier(TRUSTED_SVC_NAME)).servletRequest(this.servletRequest).docTypeInfo(DocTypeInfo.make(collectionName)).build();
        return comp.paletteResource();
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

