/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.content.appres.palettes.DocTypeInfo;
import com.ibm.bi.content.appres.palettes.Palette;
import com.ibm.bi.content.appres.palettes.PaletteRepository;
import com.ibm.bi.content.appres.palettes.ReferencesPreventDeleteException;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;

public class PaletteResourceImpl {
    private final PaletteRepository paletteRepository;
    private final DocTypeInfo docTypeInfo;

    @Inject
    public PaletteResourceImpl(PaletteRepository paletteRepository, DocTypeInfo docTypeInfo) {
        this.paletteRepository = paletteRepository;
        this.docTypeInfo = docTypeInfo;
    }

    Response.ResponseBuilder listMyPalettes() throws Exception {
        List<Palette> palettes = this.paletteRepository.listPersonal();
        return Response.ok().entity(PaletteResourceImpl.makeListPaletteEntity(palettes));
    }

    Response.ResponseBuilder listPublicPalettes() throws Exception {
        List<Palette> palettes = this.paletteRepository.listPublic();
        return Response.ok().entity(PaletteResourceImpl.makeListPaletteEntity(palettes));
    }

    static GenericEntity<List<Palette>> makeListPaletteEntity(List<Palette> palettes) {
        return new GenericEntity<List<Palette>>(palettes){};
    }

    Response.ResponseBuilder createMyPalette(String baseUrl, Palette palette) throws Exception {
        String docid = this.paletteRepository.create(palette);
        return Response.status((Response.Status)Response.Status.CREATED).header("location", (Object)this.makeLocation(baseUrl, docid));
    }

    private String makeLocation(String baseUrl, String docid) {
        return String.format("%s/%s/%s", baseUrl, this.docTypeInfo.getCollectionName(), docid);
    }

    public Response.ResponseBuilder getPalette(String documentId) throws Exception {
        Palette palette = this.paletteRepository.getPalette(documentId);
        return Response.ok((Object)palette);
    }

    public Response.ResponseBuilder deletePalette(String documentId, boolean forced) throws Exception {
        try {
            this.paletteRepository.deletePalette(documentId, forced);
            return Response.noContent();
        }
        catch (ReferencesPreventDeleteException rpdx) {
            JsonObject error = new JsonObject();
            error.put("errors", (Object)new JsonArray(new Object[]{"references from other objects prevent deletion."}));
            error.put("referers", (Object)rpdx.getReferers());
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error);
        }
    }

    public Response.ResponseBuilder updatePalette(String documentId, Palette palette) throws Exception {
        if (!palette.setDocumentIdNoClobber(documentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST);
        }
        this.paletteRepository.update(palette);
        return Response.ok();
    }
}

