/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.appres.palettes;

import com.ibm.bi.content.appres.JsonObjectHelper;
import com.ibm.bi.content.appres.home.Identity;
import com.ibm.bi.content.appres.palettes.DocTypeInfo;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;

public class PaletteStorageAdapter {
    private final Identity identity;
    private final DocTypeInfo docTypeInfo;

    @Inject
    public PaletteStorageAdapter(Identity identity, DocTypeInfo docTypeInfo) {
        this.identity = identity;
        this.docTypeInfo = docTypeInfo;
    }

    public JsonObject toStorageJson(JsonObject restJson) {
        JsonObjectHelper jsonHelper = JsonObjectHelper.copyFrom(restJson);
        jsonHelper.renameProperty("defaultName", "defaultScreenTip");
        jsonHelper.renameProperty("name", "screenTip");
        String docid = jsonHelper.getJson().getString("id");
        if (docid != null) {
            jsonHelper.getJson().put("defaultName", (Object)docid);
        }
        jsonHelper.renameProperty("id", "documentID");
        jsonHelper.getJson().put("type", (Object)"genericDocument");
        jsonHelper.getJson().put("documentType", (Object)this.docTypeInfo.getTypeName());
        jsonHelper.stringizeProperty("content");
        this.setTagsFromPublicProperty(jsonHelper);
        return jsonHelper.getJson();
    }

    public JsonObject fromStorageJson(JsonObject cmJson) {
        JsonObjectHelper jsonHelper = JsonObjectHelper.copyFrom(cmJson);
        jsonHelper.renameProperty("defaultScreenTip", "defaultName");
        jsonHelper.renameProperty("screenTip", "name");
        jsonHelper.renameProperty("documentID", "id");
        jsonHelper.renameProperty("documentType", "type");
        this.setPublicPropertyFromTags(jsonHelper);
        jsonHelper.jsonizeProperty("content");
        this.setIsMine(jsonHelper);
        return jsonHelper.getJson();
    }

    private void setIsMine(JsonObjectHelper jsonHelper) {
        JsonArray ownerJson = (JsonArray)jsonHelper.getJson().remove((Object)"owner");
        jsonHelper.getJson().put("isMine", (Object)this.isMine(this.getOwnerId(ownerJson)));
    }

    private boolean isMine(String ownerID) {
        return StringUtils.isEmpty((String)ownerID) ? false : this.identity.contains(ownerID);
    }

    private String getOwnerId(JsonArray identities) {
        if (identities == null || identities.isEmpty()) {
            return null;
        }
        return identities.getObject(0).getString("id");
    }

    void setPublicPropertyFromTags(JsonObjectHelper json) {
        boolean isPublic = json.removeFromArray("tags", "__public_true__");
        json.getJson().put("public", (Object)isPublic);
    }

    public void setTagsFromPublicProperty(JsonObjectHelper json) {
        if (!json.getJson().containsKey((Object)"public")) {
            return;
        }
        Object objPublik = json.getJson().remove((Object)"public");
        if (((Boolean)objPublik).booleanValue()) {
            this.addPublicTag(json.getJson());
        } else {
            json.removeFromArray("tags", "__public_true__");
        }
    }

    private void addPublicTag(JsonObject json) {
        JsonArray tags = json.getArray("tags");
        if (tags == null) {
            tags = new JsonArray();
            tags.add((Object)"__public_true__");
            json.put("tags", (Object)tags);
        } else {
            int idx = tags.indexOf((Object)"__public_true__");
            if (idx == -1) {
                tags.add((Object)"__public_true__");
            }
        }
    }
}

