/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.ToolkitResources;
import com.cognos.i18n.util.CurrencyUnit;
import com.cognos.i18n.util.CustomUnit;
import com.cognos.i18n.util.Measure;
import com.cognos.i18n.util.MeasureUnit;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NumericFormat {
    protected NumberFormat m_pFormat;
    protected NumberFormat m_pRuleBasedFormat;
    public static final int NUMBER = 9;
    public static final int INTEGER = 10;
    public static final int CURRENCY = 11;
    public static final int PERCENT = 12;
    public static final int SCIENTIFIC = 13;
    public static final int MEASURE = 14;
    public static final int DEFAULT = 9;
    private static final String I18N_MEASUREUNIT_RES_BASE = "./ccli18nresmurl_";
    protected int m_type = 0;
    protected MeasureUnit m_unit = null;
    protected Map m_ruleSets = null;
    protected String m_defaultMeasureUnitID = "default";
    protected String m_defaultRuleSet = "x:=pattern=;";
    protected String m_currentRuleSet = null;
    protected String m_patternPlaceholder = "pattern";
    protected String m_resourcePrefix = "mp";
    protected String m_currentPattern = null;
    protected ULocale m_locale = null;
    protected boolean m_useMultiplier = false;
    private static Map m_objCache = null;
    private static int m_objCacheSize = 0;
    private static final int m_objCacheSizeCap = 1000;
    private static Object m_mutex = new Object();

    private static synchronized void initObjCache() {
        if (m_objCache == null) {
            m_objCache = new HashMap(12);
        }
    }

    private static void addToObjCache(NumberFormat nfInstance, String objectType) {
        if (m_objCacheSize == 1000) {
            m_objCache.clear();
            m_objCacheSize = 0;
        }
        m_objCache.put(objectType, nfInstance);
        ++m_objCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NumberFormat getFromObjCache(ULocale locale, int type) {
        StringBuffer objectType = new StringBuffer(locale.getName());
        objectType.append(type);
        NumberFormat nfInstance = null;
        Object object = m_mutex;
        synchronized (object) {
            nfInstance = (NumberFormat)m_objCache.get(objectType.toString());
            if (nfInstance == null) {
                switch (type) {
                    case 9: {
                        nfInstance = NumberFormat.getNumberInstance((ULocale)locale);
                        break;
                    }
                    case 10: {
                        nfInstance = NumberFormat.getIntegerInstance((ULocale)locale);
                        break;
                    }
                    case 11: {
                        nfInstance = NumberFormat.getCurrencyInstance((ULocale)locale);
                        break;
                    }
                    case 12: {
                        nfInstance = NumberFormat.getPercentInstance((ULocale)locale);
                        break;
                    }
                    case 13: {
                        nfInstance = NumberFormat.getScientificInstance((ULocale)locale);
                        break;
                    }
                    case 14: {
                        nfInstance = NumberFormat.getNumberInstance((ULocale)locale);
                        break;
                    }
                    default: {
                        nfInstance = NumberFormat.getInstance((ULocale)locale);
                    }
                }
                NumericFormat.addToObjCache(nfInstance, objectType.toString());
            }
            return (NumberFormat)nfInstance.clone();
        }
    }

    public NumericFormat() {
        this.m_pFormat = NumberFormat.getInstance();
        if (!ToolkitResources.isUseIBMicuResources() && !ToolkitResources.m_localeSeparatorsMap.isEmpty()) {
            this.setDecimalSeparator(this.getDecimalSeparator());
            this.setGroupingSeparator(this.getGroupingSeparator());
        }
    }

    public NumericFormat(Locale locale) {
        this.m_locale = ToolkitResources.getICUDefaultLocaleForCurrentLocale(locale.toString());
        this.m_pFormat = NumberFormat.getInstance((ULocale)this.m_locale);
        if (!ToolkitResources.isUseIBMicuResources() && !ToolkitResources.m_localeSeparatorsMap.isEmpty()) {
            this.setDecimalSeparator(this.getDecimalSeparator());
            this.setGroupingSeparator(this.getGroupingSeparator());
        }
    }

    public NumericFormat(int type) {
        this(type, Locale.getDefault());
    }

    public NumericFormat(int type, Locale locale) {
        this.m_ruleSets = new Hashtable();
        this.m_locale = ToolkitResources.getICUDefaultLocaleForCurrentLocale(locale.toString());
        this.loadFormatRules(this.m_locale);
        this.m_type = type;
        if (m_objCache == null) {
            NumericFormat.initObjCache();
        }
        this.m_pFormat = NumericFormat.getFromObjCache(this.m_locale, type);
        if (!ToolkitResources.isUseIBMicuResources() && !ToolkitResources.m_localeSeparatorsMap.isEmpty()) {
            if (type == 11) {
                this.setMonetaryDecimalSeparator(this.getDecimalSeparator());
                this.setMonetaryGroupingSeparator(this.getGroupingSeparator());
            } else {
                this.setDecimalSeparator(this.getDecimalSeparator());
                this.setGroupingSeparator(this.getGroupingSeparator());
            }
        }
        if (type == 14) {
            this.m_currentPattern = ((DecimalFormat)this.m_pFormat).toPattern();
            String ruleSet = (String)this.m_ruleSets.get(this.m_defaultMeasureUnitID);
            this.m_currentRuleSet = ruleSet = this.updateNumberPatternInRule(ruleSet, this.m_patternPlaceholder, this.m_currentPattern);
            this.m_pRuleBasedFormat = new RuleBasedNumberFormat(ruleSet, this.m_locale);
        }
    }

    protected synchronized void loadFormatRules(ULocale locale) {
        try {
            Hashtable<String, Map<String, String>> langToRulesMap = new Hashtable<String, Map<String, String>>();
            String localeId = ToolkitResources.normalizeLocaleIdentifier(locale.toString());
            if (!ToolkitResources.loadResources(langToRulesMap, localeId, I18N_MEASUREUNIT_RES_BASE, "MU")) {
                localeId = "en";
                ToolkitResources.loadResources(langToRulesMap, localeId, I18N_MEASUREUNIT_RES_BASE, "MU");
            }
            this.m_ruleSets.putAll((Map)langToRulesMap.get(localeId));
        }
        catch (Exception e) {
            this.m_ruleSets.put(this.m_defaultMeasureUnitID, this.m_defaultRuleSet);
        }
        if (this.m_ruleSets.size() == 0) {
            this.m_ruleSets.put(this.m_defaultMeasureUnitID, this.m_defaultRuleSet);
        }
    }

    public String format(double value) {
        if (this.m_pRuleBasedFormat != null) {
            if (this.m_type == 14) {
                String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
                if (!this.m_currentPattern.equals(newPattern)) {
                    this.m_currentRuleSet = this.updateNumberPatternInRule(this.m_currentRuleSet, this.m_currentPattern, newPattern);
                    this.m_currentPattern = newPattern;
                }
                this.m_pRuleBasedFormat = new RuleBasedNumberFormat(this.m_currentRuleSet, this.m_locale);
            }
            return this.m_pRuleBasedFormat.format(value);
        }
        if (this.m_useMultiplier) {
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!(Math.abs(value) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format(value / multiplierValue);
            }
            if (result == null) {
                result = this.m_pFormat.format(value);
                return result;
            }
            String suffix = null;
            suffix = value >= 0.0 ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            return resultBuffer.toString();
        }
        return this.m_pFormat.format(value);
    }

    public String format(long value) {
        if (this.m_pRuleBasedFormat != null) {
            String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
            if (!this.m_currentPattern.equals(newPattern)) {
                this.m_currentRuleSet = this.updateNumberPatternInRule(this.m_currentRuleSet, this.m_currentPattern, newPattern);
                this.m_currentPattern = newPattern;
            }
            this.m_pRuleBasedFormat = new RuleBasedNumberFormat(this.m_currentRuleSet, this.m_locale);
            return this.m_pRuleBasedFormat.format(value);
        }
        if (this.m_useMultiplier) {
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!((double)Math.abs(value) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format((double)value / multiplierValue);
            }
            if (result == null) {
                result = this.m_pFormat.format(value);
                return result;
            }
            String suffix = null;
            suffix = value >= 0L ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            return resultBuffer.toString();
        }
        return this.m_pFormat.format(value);
    }

    public String format(BigDecimal value) {
        if (this.m_pRuleBasedFormat != null) {
            String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
            if (!this.m_currentPattern.equals(newPattern)) {
                this.m_currentRuleSet = this.updateNumberPatternInRule(this.m_currentRuleSet, this.m_currentPattern, newPattern);
                this.m_currentPattern = newPattern;
            }
            this.m_pRuleBasedFormat = new RuleBasedNumberFormat(this.m_currentRuleSet, this.m_locale);
            return this.m_pRuleBasedFormat.format(value);
        }
        if (this.m_useMultiplier) {
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!((double)Math.abs(value.longValue()) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format(value.divide(new BigDecimal(multiplierValue), 7));
            }
            if (result == null) {
                result = this.m_pFormat.format(value);
                return result;
            }
            String suffix = null;
            suffix = value.intValue() >= 0 ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            return resultBuffer.toString();
        }
        return this.m_pFormat.format(value);
    }

    public String format(BigInteger value) {
        if (this.m_pRuleBasedFormat != null) {
            String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
            if (!this.m_currentPattern.equals(newPattern)) {
                this.m_currentRuleSet = this.updateNumberPatternInRule(this.m_currentRuleSet, this.m_currentPattern, newPattern);
                this.m_currentPattern = newPattern;
            }
            this.m_pRuleBasedFormat = new RuleBasedNumberFormat(this.m_currentRuleSet, this.m_locale);
            return this.m_pRuleBasedFormat.format(value);
        }
        if (this.m_useMultiplier) {
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!((double)Math.abs(value.longValue()) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format(value.divide(new BigInteger(String.valueOf(multiplierValue))));
            }
            if (result == null) {
                result = this.m_pFormat.format(value);
                return result;
            }
            String suffix = null;
            suffix = value.intValue() >= 0 ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            return resultBuffer.toString();
        }
        return this.m_pFormat.format(value);
    }

    public String format(Measure value) {
        String rule = null;
        if (this.m_type == 14) {
            if (value.getUnit() instanceof CustomUnit) {
                String prefixMultiplier;
                CustomUnit unit = (CustomUnit)value.getUnit();
                String customSymbol = unit.getUnitSymbol();
                String customPrefixSymbol = unit.getPrefixMultiplierSymbol();
                if (customPrefixSymbol == null) {
                    customPrefixSymbol = "";
                }
                if (unit.getPrefixMultiplier() == 0) {
                    rule = "x:=pattern=" + customSymbol + ";";
                } else if (unit.getPrefixMultiplier() > 0) {
                    prefixMultiplier = Integer.toString((int)Math.pow(10.0, unit.getPrefixMultiplier()));
                    rule = "0: =pattern=" + customSymbol + ";" + prefixMultiplier + ": <pattern<" + customPrefixSymbol + customSymbol + ";";
                } else {
                    prefixMultiplier = Integer.toString((int)Math.pow(10.0, Math.abs(unit.getPrefixMultiplier())));
                    rule = "0.x: >%%small>;0: =pattern=" + customSymbol + ";" + "%%small:" + prefixMultiplier + ": <pattern<" + customPrefixSymbol + customSymbol + ";";
                }
                String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
                rule = this.updateNumberPatternInRule(rule, this.m_patternPlaceholder, newPattern);
                this.m_currentPattern = newPattern;
                this.m_pRuleBasedFormat = new RuleBasedNumberFormat(rule, this.m_locale);
                this.m_currentRuleSet = rule;
                ((RuleBasedNumberFormat)this.m_pRuleBasedFormat).setNumberFormat((DecimalFormat)this.m_pFormat);
            } else if (this.m_ruleSets != null && (rule = (String)this.m_ruleSets.get(value.getUnit().getUnitID())) == null) {
                rule = this.m_defaultRuleSet;
            }
            if (rule != null) {
                String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
                if (!this.m_currentPattern.equals(newPattern)) {
                    rule = this.updateNumberPatternInRule(rule, this.m_currentPattern, newPattern);
                    this.m_currentPattern = newPattern;
                }
                this.m_pRuleBasedFormat = new RuleBasedNumberFormat(rule, this.m_locale);
                this.m_currentRuleSet = rule;
                ((RuleBasedNumberFormat)this.m_pRuleBasedFormat).setNumberFormat((DecimalFormat)this.m_pFormat);
                return this.m_pRuleBasedFormat.format(value.getNumber().doubleValue());
            }
            return this.m_pFormat.format((Object)value);
        }
        if (value.getUnit() instanceof CurrencyUnit) {
            String currencyCode;
            CurrencyUnit unit = (CurrencyUnit)value.getUnit();
            String tmpCurSymb = this.getCurrencySymbol();
            String tmpIntCurSymb = this.getInternationalCurrencySymbol();
            String currencySymb = unit.getCurrencySymbol();
            if (currencySymb.length() > 0) {
                this.setCurrencySymbol(unit.getCurrencySymbol());
            }
            if ((currencyCode = unit.getCurrencyCodeSymbol()).length() > 0) {
                this.setInternationalCurrencySymbol(unit.getCurrencyCodeSymbol());
            }
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!(Math.abs(value.getNumber().doubleValue()) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format(value.getNumber().doubleValue() / multiplierValue);
            }
            if (result == null) {
                result = this.m_pFormat.format(value.getNumber().doubleValue());
                return result;
            }
            String suffix = null;
            suffix = value.getNumber().doubleValue() >= 0.0 ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            result = resultBuffer.toString();
            this.setCurrencySymbol(tmpCurSymb);
            this.setInternationalCurrencySymbol(tmpIntCurSymb);
            return result;
        }
        if (value.getUnit() instanceof CustomUnit) {
            CustomUnit unit = (CustomUnit)value.getUnit();
            String result = null;
            String multiplierPrefixSymbol = "";
            double multiplierValue = 1.0;
            for (int multiplier = 12; multiplier > 0 && result == null; multiplier -= 3) {
                String res_id;
                multiplierValue = Math.pow(10.0, multiplier);
                if (!(Math.abs(value.getNumber().doubleValue()) >= multiplierValue) || (multiplierPrefixSymbol = (String)this.m_ruleSets.get(res_id = this.m_resourcePrefix + String.valueOf(multiplier))) == null) continue;
                result = this.m_pFormat.format(value.getNumber().doubleValue() / multiplierValue);
            }
            if (result == null) {
                result = this.m_pFormat.format(value.getNumber().doubleValue());
                return result;
            }
            String suffix = null;
            suffix = value.getNumber().doubleValue() >= 0.0 ? ((DecimalFormat)this.m_pFormat).getPositiveSuffix() : ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
            int sufixIndex = result.lastIndexOf(suffix);
            StringBuffer resultBuffer = new StringBuffer(result);
            resultBuffer.insert(sufixIndex, multiplierPrefixSymbol);
            return resultBuffer.toString();
        }
        return this.m_pFormat.format(value.getNumber().doubleValue());
    }

    String updateNumberPatternInRule(String rule, String currentPattern, String newPattern) {
        StringBuffer tmpRule = new StringBuffer(rule);
        int indPattern = tmpRule.toString().indexOf(currentPattern);
        while (indPattern >= 0) {
            tmpRule.replace(indPattern, indPattern + currentPattern.length(), newPattern);
            indPattern = tmpRule.toString().indexOf(currentPattern, indPattern + 1);
        }
        return tmpRule.toString();
    }

    public Number parse(String numericString) throws ParseException {
        return this.m_pFormat.parse(numericString);
    }

    public void applyPattern(String pattern) {
        DecimalFormat fmt = (DecimalFormat)this.m_pFormat;
        fmt.applyPattern(pattern);
    }

    public String getPattern() {
        DecimalFormat fmt = (DecimalFormat)this.m_pFormat;
        return fmt.toPattern();
    }

    public void setPadCharacter(char pad) {
        DecimalFormat fmt = (DecimalFormat)this.m_pFormat;
        fmt.setPadCharacter(pad);
    }

    public void setPattern(String pattern) {
        DecimalFormat fmt = (DecimalFormat)this.m_pFormat;
        fmt.applyPattern(pattern);
    }

    public String getCurrencySymbol() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getCurrencySymbol();
    }

    public char getDecimalSeparator() {
        if (!ToolkitResources.isUseIBMicuResources() && !ToolkitResources.m_localeSeparatorsMap.isEmpty()) {
            List<String> theList = null;
            theList = this.m_locale != null ? ToolkitResources.getSeparatorsListForLocale(new Locale(this.m_locale.getName())) : ToolkitResources.getSeparatorsListForLocale(Locale.getDefault());
            if (theList != null) {
                return theList.get(0).charAt(0);
            }
        }
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getDecimalSeparator();
    }

    public String getListSeparator(Locale locale) {
        return ToolkitResources.getListSeparator(locale);
    }

    public char getGroupingSeparator() {
        if (!ToolkitResources.isUseIBMicuResources() && !ToolkitResources.m_localeSeparatorsMap.isEmpty()) {
            List<String> theList = null;
            theList = this.m_locale != null ? ToolkitResources.getSeparatorsListForLocale(new Locale(this.m_locale.getName())) : ToolkitResources.getSeparatorsListForLocale(Locale.getDefault());
            if (theList != null) {
                return theList.get(2).charAt(0);
            }
        }
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getGroupingSeparator();
    }

    public String getInfinity() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getInfinity();
    }

    public String getInternationalCurrencySymbol() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getInternationalCurrencySymbol();
    }

    public char getMinusSign() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getMinusSign();
    }

    public char getMonetaryDecimalSeparator() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getMonetaryDecimalSeparator();
    }

    public char getMonetaryGroupingSeparator() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getMonetaryGroupingSeparator();
    }

    public String getNaN() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getNaN();
    }

    public String getNegativePrefix() {
        return ((DecimalFormat)this.m_pFormat).getNegativePrefix();
    }

    public String getNegativeSuffix() {
        return ((DecimalFormat)this.m_pFormat).getNegativeSuffix();
    }

    public char getPercent() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getPercent();
    }

    public char getPerMill() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getPerMill();
    }

    public char getPlusSign() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getPlusSign();
    }

    public String getPositivePrefix() {
        return ((DecimalFormat)this.m_pFormat).getPositivePrefix();
    }

    public String getPositiveSuffix() {
        return ((DecimalFormat)this.m_pFormat).getPositiveSuffix();
    }

    public char getZeroDigit() {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        return dfs.getZeroDigit();
    }

    public void setCurrencySymbol(String currency) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setCurrencySymbol(currency);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setCurrency(String currencyISOCode) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        String currencySymbol = ToolkitResources.getSymbolForCurrencyCode(currencyISOCode);
        if (currencySymbol == null) {
            currencySymbol = currencyISOCode;
        }
        dfs.setCurrencySymbol(currencySymbol);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public SymbolLocation getPercentLocation() {
        String pattern = this.getPattern();
        int perInd = pattern.indexOf(37);
        if (perInd < 0) {
            return SymbolLocation.NONE;
        }
        int digInd = pattern.indexOf(48);
        if (digInd < 0) {
            return SymbolLocation.NONE;
        }
        if (digInd < perInd) {
            return SymbolLocation.RIGHT;
        }
        return SymbolLocation.LEFT;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setDecimalSeparator(decimalSeparator);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setGroupingSeparator(char groupingSeparator) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setGroupingSeparator(groupingSeparator);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setGroupingSize(int groupingSize) {
        ((DecimalFormat)this.m_pFormat).setGroupingSize(groupingSize);
    }

    public void setInfinity(String infinity) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setInfinity(infinity);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setInternationalCurrencySymbol(String currency) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setInternationalCurrencySymbol(currency);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setMinusSign(char minusSign) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setMinusSign(minusSign);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setMinusSign(String minusSign) {
        DecimalFormat fmt = (DecimalFormat)this.m_pFormat;
        if (minusSign.length() == 1) {
            this.setMinusSign(minusSign.charAt(0));
        } else if (minusSign.length() > 1) {
            fmt.setNegativePrefix(minusSign.substring(0, 1));
            fmt.setNegativeSuffix(minusSign.substring(1, 2));
        }
    }

    public void setMonetaryDecimalSeparator(char sep) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setMonetaryDecimalSeparator(sep);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setMonetaryGroupingSeparator(char sep) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setMonetaryGroupingSeparator(sep);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setNaN(String NaN) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setNaN(NaN);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setPercent(char percent) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setPercent(percent);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setPerMill(char perMill) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setPerMill(perMill);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setPlusSign(char plus) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setPlusSign(plus);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setZeroDigit(char zeroDigit) {
        DecimalFormatSymbols dfs = ((DecimalFormat)this.m_pFormat).getDecimalFormatSymbols();
        dfs.setZeroDigit(zeroDigit);
        ((DecimalFormat)this.m_pFormat).setDecimalFormatSymbols(dfs);
    }

    public void setGroupingUsed(boolean newValue) {
        this.m_pFormat.setGroupingUsed(newValue);
    }

    public boolean isGroupingUsed() {
        return this.m_pFormat.isGroupingUsed();
    }

    public void setIntegerFormatWidth(int newValue) {
        ((DecimalFormat)this.m_pFormat).setFormatWidth(newValue);
    }

    public void setMaximumFractionDigits(int newValue) {
        this.m_pFormat.setMaximumFractionDigits(newValue);
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.m_pFormat.setMaximumIntegerDigits(newValue);
    }

    public void setMinimumFractionDigits(int newValue) {
        this.m_pFormat.setMinimumFractionDigits(newValue);
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.m_pFormat.setMinimumIntegerDigits(newValue);
    }

    public int getMaximumFractionDigits() {
        return this.m_pFormat.getMaximumFractionDigits();
    }

    public int getMaximumIntegerDigits() {
        return this.m_pFormat.getMaximumIntegerDigits();
    }

    public int getMinimumFractionDigits() {
        return this.m_pFormat.getMinimumFractionDigits();
    }

    public int getMinimumIntegerDigits() {
        return this.m_pFormat.getMinimumIntegerDigits();
    }

    public static String getSymbolForCurrencyCode(String currencyCode) {
        return ToolkitResources.getSymbolForCurrencyCode(currencyCode);
    }

    public static String getCurrencyDescription(String currencyCode, String languageId) {
        return ToolkitResources.getCurrencyDescription(currencyCode, languageId);
    }

    public static String getCurrencyDescription(String currencyCode, Locale locale) {
        return ToolkitResources.getCurrencyDescription(currencyCode, locale.toString());
    }

    public void setMeasureUnit(MeasureUnit measureUnit) {
        this.m_unit = measureUnit;
        if (this.m_type == 14) {
            if (measureUnit instanceof CustomUnit) {
                String prefixMultiplier;
                CustomUnit unit = (CustomUnit)measureUnit;
                String customSymbol = unit.getUnitSymbol();
                String customPrefixSymbol = unit.getPrefixMultiplierSymbol();
                String rule = null;
                if (unit.getPrefixMultiplier() == 0) {
                    rule = "x:=pattern=" + customSymbol + ";";
                } else if (unit.getPrefixMultiplier() > 0) {
                    prefixMultiplier = Integer.toString((int)Math.pow(10.0, unit.getPrefixMultiplier()));
                    rule = "0: =pattern=" + customSymbol + ";" + prefixMultiplier + ": <pattern<" + customPrefixSymbol + customSymbol + ";";
                } else {
                    prefixMultiplier = Integer.toString((int)Math.pow(10.0, Math.abs(unit.getPrefixMultiplier())));
                    rule = "0.x: >%%small>;0: =pattern=" + customSymbol + ";" + "%%small:" + prefixMultiplier + ": <pattern<" + customPrefixSymbol + customSymbol + ";";
                }
                String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
                rule = this.updateNumberPatternInRule(rule, this.m_patternPlaceholder, newPattern);
                this.m_currentPattern = newPattern;
                this.m_pRuleBasedFormat = new RuleBasedNumberFormat(rule, this.m_locale);
                this.m_currentRuleSet = rule;
            } else {
                String rule = (String)this.m_ruleSets.get(this.m_unit.getUnitID());
                String newPattern = ((DecimalFormat)this.m_pFormat).toPattern();
                if (!this.m_currentPattern.equals(newPattern)) {
                    rule = this.updateNumberPatternInRule(rule, this.m_currentPattern, newPattern);
                    this.m_currentPattern = newPattern;
                }
                this.m_pFormat = new RuleBasedNumberFormat(rule, this.m_locale);
                this.m_currentRuleSet = rule;
            }
        } else if (measureUnit instanceof CurrencyUnit) {
            String currencyCode;
            CurrencyUnit unit = (CurrencyUnit)measureUnit;
            String currencySymbol = unit.getCurrencySymbol();
            if (currencySymbol.length() > 0) {
                this.setCurrencySymbol(currencySymbol);
            }
            if ((currencyCode = unit.getCurrencyCodeSymbol()).length() > 0) {
                this.setInternationalCurrencySymbol(unit.getCurrencyCodeSymbol());
            }
            this.m_useMultiplier = true;
        } else if (measureUnit instanceof CustomUnit) {
            CustomUnit unit = (CustomUnit)measureUnit;
            this.m_useMultiplier = true;
        }
    }

    public MeasureUnit getMeasureUnit() {
        return this.m_unit;
    }

    public void setUseMultiplier(boolean setting) {
        this.m_useMultiplier = setting;
    }

    public boolean isUsingMultiplier() {
        return this.m_useMultiplier;
    }

    public static enum SymbolLocation {
        NONE,
        RIGHT,
        LEFT,
        BOTH;

    }
}

