/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.content.core.application;

import com.ibm.bi.cognos.content.core.application.IPFPathOverrideFilter;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@IPFPathOverrideFilter
public class PFPathOverrideFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PFPathOverrideFilter.class);
    static final String PUBLIC_FOLDERS = ".public_folders";
    static final String PROFILE_SETTINGS = "/bi/v1/users/~/user_profile_settings?fields=rootFolder_teamContent";
    static final String TEAM_CONTENT = "rootFolder_teamContent";
    @Context
    HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo uriInfo = requestContext.getUriInfo();
        String oldPath = uriInfo.getPath();
        if (StringUtils.contains((String)oldPath, (String)PUBLIC_FOLDERS)) {
            UriBuilder builder = uriInfo.getBaseUriBuilder();
            StringBuilder newPath = new StringBuilder();
            List pathSegments = uriInfo.getPathSegments(false);
            for (PathSegment segment : pathSegments) {
                newPath.append(this.transform(segment.getPath())).append("/");
            }
            newPath.deleteCharAt(newPath.length() - 1);
            requestContext.setRequestUri(builder.path(newPath.toString()).build(new Object[0]));
        }
    }

    private String transform(String path) {
        if (StringUtils.equals((String)path, (String)PUBLIC_FOLDERS)) {
            return this.getTeamFolders();
        }
        return path;
    }

    String getTeamFolders() {
        String tf = PUBLIC_FOLDERS;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(this.servletRequest);){
            String teamContent;
            JsonObject me = client.getResource(PROFILE_SETTINGS, "application/json");
            if (me != null && me.containsKey((Object)TEAM_CONTENT) && (teamContent = me.getString(TEAM_CONTENT)) != null) {
                tf = teamContent;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return tf;
    }
}

