/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.content.core.exceptions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ContentException
extends RuntimeException {
    public static final String ERROR_PROP = "error";
    private int statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private final Map<String, Object> propMap;
    private static final long serialVersionUID = 2189621683499990677L;

    public ContentException(String msg) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), msg);
    }

    public ContentException(Response.Status status) {
        this(status.getStatusCode(), status.getReasonPhrase(), null);
    }

    public ContentException(Response.Status status, String msg) {
        this(status.getStatusCode(), msg, null);
    }

    public ContentException(int statusCode, String msg) {
        this(statusCode, msg, null);
    }

    public ContentException(Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), cause);
    }

    public ContentException(Response.Status status, Throwable cause) {
        this(status.getStatusCode(), cause);
    }

    public ContentException(int statusCode, Throwable cause) {
        super(cause);
        this.propMap = new HashMap<String, Object>();
        this.propMap.put(ERROR_PROP, ContentException.getErrorMessage(cause));
        this.statusCode = statusCode;
    }

    public ContentException(String msg, Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), msg, cause);
    }

    public ContentException(int statusCode, String msg, Throwable cause) {
        super(msg, cause);
        this.propMap = new HashMap<String, Object>();
        this.propMap.put(ERROR_PROP, msg);
        this.statusCode = statusCode;
    }

    public ContentException(int statusCode, Map<String, ?> errorProperties, Throwable cause) {
        super(ContentException.getErrorMessage(errorProperties, cause), cause);
        this.propMap = new HashMap(errorProperties);
        if (!this.propMap.containsKey(ERROR_PROP)) {
            this.propMap.put(ERROR_PROP, ContentException.getErrorMessage(cause));
        }
        this.statusCode = statusCode;
    }

    public ContentException(Map<String, ?> errorProperties, Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), errorProperties, cause);
    }

    public Map<String, ?> getPropertyMap() {
        return Collections.unmodifiableMap(this.propMap);
    }

    public void addProperty(String name, Object value) {
        if (!ERROR_PROP.equals(name)) {
            this.propMap.put(name, value);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    static String getErrorMessage(Map<String, ?> errorProperties, Throwable cause) {
        Object propMsg = errorProperties.get(ERROR_PROP);
        String msg = propMsg != null && propMsg instanceof String ? (String)propMsg : ContentException.getErrorMessage(cause);
        return msg;
    }

    static String getErrorMessage(Throwable cause) {
        String msg = cause != null ? (cause.getMessage() != null ? cause.getMessage() : "Unexpected " + cause.getClass().getSimpleName()) : "Unexpected fault";
        return msg;
    }
}

