/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.content.core.exceptions;

import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonWriter;
import com.ibm.bi.platform.commons.messages.HttpException;
import com.ibm.bi.soap.services.SoapException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;

@Provider
public class ContentExceptionMapper
implements ExceptionMapper<Exception> {
    @Context
    private HttpServletRequest request;

    public Response toResponse(Exception cause) {
        Response response = null;
        if (cause instanceof WebApplicationException) {
            if (cause.getCause() instanceof RestException) {
                response = this.constructContentExceptionResponse((RestException)cause.getCause());
            } else if (cause.getCause() instanceof SoapException) {
                response = this.constructSoapExceptionResponse((SoapException)cause.getCause());
            } else {
                WebApplicationException wae = (WebApplicationException)cause;
                response = wae.getResponse();
            }
        } else {
            response = cause instanceof RestException ? this.constructContentExceptionResponse((RestException)cause) : (cause instanceof HttpException ? this.constructContentExceptionResponse((HttpException)cause) : (cause instanceof SoapException ? this.constructSoapExceptionResponse((SoapException)cause) : this.constructContentExceptionResponse(new RestException(cause))));
        }
        return response;
    }

    public static String writeJson(RestException restEx, Locale locale, boolean bPretty) {
        int MAX_CAUSE = 20;
        String ERRORS_NAME = "errors";
        JsonObject jsonErrors = new JsonObject();
        JsonArray jsonMessages = new JsonArray();
        String msg = restEx.getLocalizedMessage(locale);
        if (StringUtils.isNotBlank((String)msg)) {
            JsonObject firstMessage = RestException.getMessageInJson(msg);
            jsonMessages.add((Object)firstMessage);
        }
        Throwable cause = restEx.getCause();
        for (int causeCnt = 0; cause != null && causeCnt < 20; ++causeCnt, cause = cause.getCause()) {
            String causeMsg = cause.getMessage();
            if (StringUtils.isBlank((String)causeMsg)) {
                causeMsg = cause.getClass().getName();
            }
            JsonObject jsonMsg = RestException.getMessageInJson(causeMsg);
            jsonMessages.add((Object)jsonMsg);
        }
        jsonErrors.put("errors", (Object)jsonMessages);
        DefaultJsonFactory jsonFactory = new DefaultJsonFactory();
        JsonWriter jsonWriter = new JsonWriter((JsonFactory)jsonFactory, bPretty);
        StringWriter w = new StringWriter();
        try {
            jsonWriter.write((Writer)w, (Object)jsonErrors);
        }
        catch (Exception ex) {
            return "";
        }
        return w.toString();
    }

    private Response constructContentExceptionResponse(HttpException e) {
        return Response.status((int)e.getStatusCode()).entity((Object)RestException.getMessageInJson(e.getLocalizedMessage())).type("application/json").build();
    }

    private Response constructContentExceptionResponse(RestException e) {
        return Response.status((int)e.getStatusCode()).entity((Object)ContentExceptionMapper.writeJson(e, this.request.getLocale(), true)).type("application/json").build();
    }

    private Response constructSoapExceptionResponse(SoapException e) {
        return Response.status((int)e.getStatusCode()).entity(e.getErrorDetails()).type("application/json").build();
    }
}

