/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.cognos.content.core.exceptions;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.json.JsonObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;

public class RestException
extends RuntimeException {
    private static final long serialVersionUID = -8815293803105647190L;
    public static final String ERROR_PROP = "error";
    private int statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private final Map<String, Object> propMap = new LinkedHashMap<String, Object>();
    private ContentMessage mMessage = null;
    private static final String CODE_NAME = "code";
    private static final String MESSAGE_NAME = "message";
    private static final String LEVEL_NAME = "level";
    private static final String ERROR_LEVEL_NAME = "error";
    private static final String DESCRIPTION_NAME = "description";
    private static final String MORE_INFO_NAME = "more_info";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(\\w+-\\w+-\\d+)\\s+(.*)");

    public RestException(int httpStatus, ContentMessage msg) {
        this.mMessage = msg;
        this.statusCode = httpStatus;
    }

    public RestException(int status, ContentMessage msg, Throwable cause) {
        super(cause);
        this.mMessage = msg;
        this.statusCode = status;
    }

    public RestException(Throwable cause) {
        this(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), new ContentMessage(MessageKeys.INTERNAL_ERROR), cause);
    }

    public Map<String, ?> getPropertyMap() {
        return Collections.unmodifiableMap(this.propMap);
    }

    public void addProperty(String name, Object value) {
        if (!"error".equals(name)) {
            this.propMap.put(name, value);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static JsonObject getMessageInJson(String message) {
        Matcher matcher = MESSAGE_PATTERN.matcher(message);
        String errorCode = "";
        if (matcher.matches()) {
            errorCode = matcher.group(1);
        }
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        propMap.put(CODE_NAME, errorCode);
        propMap.put(MESSAGE_NAME, message);
        propMap.put(LEVEL_NAME, "error");
        propMap.put(DESCRIPTION_NAME, "");
        propMap.put(MORE_INFO_NAME, "");
        JsonObject jsonMessage = new JsonObject();
        jsonMessage.putAll(propMap);
        return jsonMessage;
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.mMessage == null) {
            return "";
        }
        return this.mMessage.getLocalizedMessage(locale);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }
}

