/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import com.ibm.bi.content.apps.resources.BaseResource;
import com.ibm.bi.content.echocache.EchoCacheResourceImpl;
import com.ibm.bi.content.echocache.EchoComponentManager;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/echo")
@Api(value="echocache", description="bounce stuff off the server to trick the browser into caching it")
public class EchoCacheResource
extends BaseResource {
    private static final Logger LOG = LoggerFactory.getLogger(EchoCacheResource.class);
    private static final String DEFAULT_TTL_DAYS = "180";

    @GET
    @Path(value="/{cacheId:.*}")
    @Produces(value={"*"})
    @ApiOperation(value="reply with content temporarily stored by previous PUT")
    public Response readFromCache(@PathParam(value="cacheId") String cacheId, @CookieParam(value="cam_passport") String passportID) throws Exception {
        return this.getImpl().getCachedContent(cacheId, passportID);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"text/plain", "*"})
    @ApiOperation(value="stash some content temporarily, at a new location.  GET it within 30 seconds.")
    public Response addNewToCache(@HeaderParam(value="Content-Type") MediaType mediaType, @CookieParam(value="cam_passport") String passportID, @DefaultValue(value="180") @QueryParam(value="ttl") int ttlDays, @ApiParam InputStream body) throws Exception {
        return this.getImpl().updater().withPassport(passportID).withBaseUrl(this.buildBaseURL()).withTTL(ttlDays).withContent(mediaType, body).updateCache();
    }

    @PUT
    @Path(value="/{contentId:.*}")
    @Consumes(value={"text/plain", "*"})
    @ApiOperation(value="stash some content temporarily at specified location.  GET it within 30 seconds.")
    public Response addToCache(@PathParam(value="contentId") String contentId, @HeaderParam(value="Content-Type") MediaType mediaType, @CookieParam(value="cam_passport") String passportID, @DefaultValue(value="180") @QueryParam(value="ttl") int ttlDays, @ApiParam InputStream body) throws Exception {
        return this.getImpl().updater(contentId).withPassport(passportID).withBaseUrl(this.buildBaseURL()).withTTL(ttlDays).withContent(mediaType, body).updateCache();
    }

    private EchoCacheResourceImpl getImpl() {
        Supplier implSupplier = (Supplier)this.servletRequest.getServletContext().getAttribute(EchoComponentManager.IMPL_CONTEXT_KEY);
        EchoCacheResourceImpl impl = (EchoCacheResourceImpl)implSupplier.get();
        if (impl == null) {
            LOG.warn("EchoCacheResourceImpl not available yet.");
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return impl;
    }

    void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }
}

