/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import com.google.common.cache.Cache;
import com.ibm.bi.content.echocache.CacheKey;
import com.ibm.bi.content.echocache.CacheKeyFactory;
import com.ibm.bi.content.echocache.Content;
import com.ibm.bi.content.echocache.PerSessionItemCounter;
import com.ibm.bi.content.echocache.SizeLimitedInputStreamFilter;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoCacheResourceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(EchoCacheResourceImpl.class);
    private final Cache<CacheKey, Content> cache;
    private final CacheKeyFactory keyFactory;
    private final long itemSizeLimit;
    private final PerSessionItemCounter sessionItemCounter;

    EchoCacheResourceImpl(Cache<CacheKey, Content> cache, CacheKeyFactory keyFactory, long sizeLimit, PerSessionItemCounter sessionItemCounter) {
        this.cache = cache;
        this.keyFactory = keyFactory;
        this.itemSizeLimit = sizeLimit;
        this.sessionItemCounter = sessionItemCounter;
    }

    public Response getCachedContent(String locationKey, String passportID) {
        Content content = (Content)this.cache.getIfPresent((Object)this.keyFactory.makeExisting(locationKey, passportID));
        if (content == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)content.getContent(), (MediaType)content.getMimeType()).cacheControl(this.makeCacheControl(content.getTtlDays())).expires(this.calcExpires(content.getTtlDays())).build();
    }

    Updater updater() {
        return new Updater(null);
    }

    Updater updater(String locationId) {
        return new Updater(locationId);
    }

    CacheControl makeCacheControl(int ttlDays) {
        CacheControl cc = new CacheControl();
        cc.setMaxAge(this.calcMaxAge(ttlDays));
        cc.setPrivate(true);
        return cc;
    }

    int calcMaxAge(int ttlDays) {
        return (int)TimeUnit.SECONDS.convert(ttlDays, TimeUnit.DAYS);
    }

    Date calcExpires(long ttlDays) {
        LocalDate ld = LocalDate.now().plusDays(ttlDays);
        long ms_since_epoch = TimeUnit.MILLISECONDS.convert(ld.toEpochDay(), TimeUnit.DAYS);
        return new Date(ms_since_epoch);
    }

    private String makeLocation(String baseUrl, String resourceId) {
        return baseUrl + "/echo/" + resourceId;
    }

    public long getItemSizeLimit() {
        return this.itemSizeLimit;
    }

    public class Updater {
        private String passport;
        private int ttlDays;
        private String baseUrl;
        private MediaType mediaType;
        private InputStream isContent;
        private final String existingId;

        Updater(String existingId) {
            this.existingId = existingId;
        }

        public Updater withPassport(String passport) {
            this.passport = passport;
            return this;
        }

        public Updater withTTL(int ttlDays) {
            this.ttlDays = ttlDays;
            return this;
        }

        public Updater withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Updater withContent(MediaType mediaType, InputStream isContent) {
            this.mediaType = mediaType;
            this.isContent = isContent;
            return this;
        }

        private Response doUpdate() throws IOException {
            EchoCacheResourceImpl.this.sessionItemCounter.increment(this.passport);
            CacheKey key = this.existingId == null ? EchoCacheResourceImpl.this.keyFactory.makeNew(this.passport) : EchoCacheResourceImpl.this.keyFactory.makeExisting(this.existingId, this.passport);
            Content content = this.loadContent();
            EchoCacheResourceImpl.this.cache.put((Object)key, (Object)content);
            return Response.status((Response.Status)Response.Status.CREATED).header("location", (Object)EchoCacheResourceImpl.this.makeLocation(this.baseUrl, key.getContentId())).build();
        }

        public Response updateCache() {
            try {
                return this.doUpdate();
            }
            catch (IOException iox) {
                LOG.debug("exception while reading request content to be added cache", (Throwable)iox);
                throw new WebApplicationException(400);
            }
            catch (SizeLimitedInputStreamFilter.TooBigException tbx) {
                LOG.warn("rejected cache add because resource was too big.");
                throw new WebApplicationException(413);
            }
            catch (PerSessionItemCounter.TooManyException tmx) {
                LOG.warn("rejected cache add because this session has too many.");
                throw new WebApplicationException(429);
            }
        }

        private Content loadContent() throws IOException {
            byte[] content = IOUtils.toByteArray((InputStream)((Object)new SizeLimitedInputStreamFilter(EchoCacheResourceImpl.this.itemSizeLimit, this.isContent)));
            return new Content(this.mediaType, content, this.ttlDays);
        }
    }
}

