/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import com.google.common.base.Ticker;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.content.echocache.EchoContentCache;
import com.ibm.bi.content.echocache.IdSupplier;
import com.ibm.bi.content.echocache.ResourceImplSupplier;
import com.ibm.bi.content.echocache.config.DynamicConfigSource;
import com.ibm.bi.content.echocache.config.DynamicConfigSourceFromCPF;
import com.ibm.bi.content.echocache.config.EchoServiceConfiguration;
import com.ibm.bi.content.echocache.config.EchoServiceConfigurationController;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class EchoComponentManager
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(EchoComponentManager.class);
    static final String IMPL_CONTEXT_KEY = EchoComponentManager.class.getName() + ".echoCache";
    @Resource(lookup="concurrent/biScheduledExecSvc")
    private ScheduledExecutorService scheduledExecSvc;
    private final Supplier<String> idSupplier;
    private final Ticker ticker;
    private ServletContext servletContext;
    private EchoServiceConfigurationController configurationController;
    private EchoContentCache echoCacheService;
    private Object mutex = this;
    private ScheduledFuture<?> pendingReconfigure;
    private EchoServiceConfiguration currentConfiguration = EchoServiceConfiguration.DEFAULT;
    private int reconfigureDelaySeconds = 10;
    private EventBus eventBus = new EventBus();
    private AtomicBoolean isContextInitialized = new AtomicBoolean(false);
    private ResourceImplSupplier echoResourceImplSupplier = new ResourceImplSupplier();
    private Runnable reconfigureRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = EchoComponentManager.this.mutex;
            synchronized (object) {
                EchoComponentManager.this.pendingReconfigure = null;
                EchoServiceConfiguration pendingConfiguration = EchoComponentManager.this.configurationController.loadConfiguration();
                if (EchoComponentManager.this.currentConfiguration.equals(pendingConfiguration)) {
                    LOG.debug("reconfiguring: new config is same as old, so do nothing");
                    return;
                }
                EchoComponentManager.this.currentConfiguration = pendingConfiguration;
                LOG.debug("reconfiguring, first stop the old cache service");
                EchoComponentManager.this.stopEchoCache();
                LOG.debug("reconfiguring, then start with new configuration");
                EchoComponentManager.this.startNewEchoCache();
                EchoComponentManager.this.eventBus.post((Object)new ReconfigureComplete());
            }
        }
    };

    public EchoComponentManager() {
        this.ticker = Ticker.systemTicker();
        this.idSupplier = new IdSupplier();
    }

    EchoComponentManager(Ticker ticker, Supplier<String> idSupplier) {
        this.ticker = ticker;
        this.idSupplier = idSupplier;
    }

    protected void setExcutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecSvc = scheduledExecutorService;
    }

    protected void setReconfigureDelaySeconds(int reconfigureDelaySeconds) {
        this.reconfigureDelaySeconds = reconfigureDelaySeconds;
    }

    public void contextInitialized(ServletContextEvent contextEvent) {
        LOG.debug("context initialized");
        this.isContextInitialized.set(true);
        this.startNewEchoCache();
        this.servletContext = contextEvent.getServletContext();
        this.servletContext.setAttribute(IMPL_CONTEXT_KEY, (Object)this.echoResourceImplSupplier);
        this.waitForReady();
    }

    protected void waitForReady() {
        LOG.info("waiting for ConfigurationPropertyFactory");
        ConfigurationPropertyFactory.whenReady(cpf -> this.onConfigurationReady(new DynamicConfigSourceFromCPF((ConfigurationPropertyFactory)cpf)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConfigurationReady(DynamicConfigSource configSource) {
        LOG.debug("configuration is ready, proceeding to configure and [re]start echo service");
        Object object = this.mutex;
        synchronized (object) {
            this.eventBus.register((Object)this);
            this.configurationController = new EchoServiceConfigurationController(configSource, this.eventBus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onConfigChange(EchoServiceConfigurationController.ConfigChange changeEvent) {
        LOG.debug("received config change event");
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isContextInitialized.get()) {
                LOG.debug("ignore config change notification because the web context is destroyed");
                return;
            }
            this.scheduleReconfigure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReconfigure() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingReconfigure != null) {
                LOG.debug("a reconfigure is already scheduled");
            } else {
                LOG.debug("config changed, scheduling reconfigure 10 seconds from now");
                this.pendingReconfigure = this.scheduledExecSvc.schedule(this.reconfigureRunnable, (long)this.reconfigureDelaySeconds, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewEchoCache() {
        Object object = this.mutex;
        synchronized (object) {
            LOG.debug("starting echo cache with configuration: {}", (Object)this.currentConfiguration);
            this.echoCacheService = new EchoContentCache(this.scheduledExecSvc, this.idSupplier, this.ticker, this.currentConfiguration);
            this.echoCacheService.start();
            this.echoResourceImplSupplier.setImpl(this.echoCacheService.getResourceImpl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEchoCache() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingReconfigure != null) {
                this.pendingReconfigure.cancel(false);
                this.pendingReconfigure = null;
            }
            if (this.echoCacheService != null) {
                this.echoCacheService.stop();
                this.echoCacheService = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent contextEvent) {
        Object object = this.mutex;
        synchronized (object) {
            this.isContextInitialized.set(false);
            this.configurationController.enableNotifications(false);
            LOG.debug("context destroyed");
            this.stopEchoCache();
        }
    }

    protected EventBus getEventBus() {
        return this.eventBus;
    }

    public static class ReconfigureComplete {
    }
}

