/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.ibm.bi.content.echocache.CacheKey;
import com.ibm.bi.content.echocache.CacheKeyFactory;
import com.ibm.bi.content.echocache.Content;
import com.ibm.bi.content.echocache.EchoCacheResourceImpl;
import com.ibm.bi.content.echocache.PerSessionItemCounter;
import com.ibm.bi.content.echocache.config.EchoServiceConfiguration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class EchoContentCache {
    private final ScheduledExecutorService scheduledExecSvc;
    private final Supplier<String> idSupplier;
    private final Ticker ticker;
    private final EchoServiceConfiguration config;
    private Cache<CacheKey, Content> contentCache;
    private LoadingCache<String, AtomicInteger> perSessionCounterCache;
    private EchoCacheResourceImpl resourceImpl;
    private ScheduledFuture<?> futureScheduledCleanups;
    Runnable periodicCleanupRunnable = new Runnable(){

        @Override
        public void run() {
            EchoContentCache.this.contentCache.cleanUp();
            EchoContentCache.this.perSessionCounterCache.cleanUp();
        }
    };

    EchoContentCache(ScheduledExecutorService scheduledExecSvc, Supplier<String> idSupplier, Ticker ticker, EchoServiceConfiguration config) {
        this.scheduledExecSvc = scheduledExecSvc;
        this.idSupplier = idSupplier;
        this.ticker = ticker;
        this.config = config;
        this.construct();
    }

    void construct() {
        this.perSessionCounterCache = CacheBuilder.newBuilder().maximumSize((long)this.config.maxCachedSessionCounters).ticker(this.ticker).expireAfterWrite((long)(this.config.echoCacheExpirySec * 2), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

            public AtomicInteger load(String sessionID) throws Exception {
                return new AtomicInteger(0);
            }
        });
        PerSessionItemCounter perSessionCounters = new PerSessionItemCounter(this.config.maxItemsPerSession, this.perSessionCounterCache);
        this.contentCache = CacheBuilder.newBuilder().maximumWeight(0x100000L * this.config.overallSizeLimitMB).weigher(this.makeWeigher()).expireAfterWrite((long)this.config.echoCacheExpirySec, TimeUnit.SECONDS).ticker(this.ticker).removalListener(this.makeContentRemovalListener(perSessionCounters)).build();
        this.resourceImpl = new EchoCacheResourceImpl(this.contentCache, new CacheKeyFactory(this.idSupplier), this.config.itemSizeLimit, perSessionCounters);
    }

    EchoCacheResourceImpl getResourceImpl() {
        return this.resourceImpl;
    }

    RemovalListener<CacheKey, Content> makeContentRemovalListener(final PerSessionItemCounter perSessionCounters) {
        return new RemovalListener<CacheKey, Content>(){

            public void onRemoval(RemovalNotification<CacheKey, Content> notification) {
                perSessionCounters.decrement(((CacheKey)notification.getKey()).getPassportId());
            }
        };
    }

    Weigher<CacheKey, Content> makeWeigher() {
        return new Weigher<CacheKey, Content>(){

            public int weigh(CacheKey key, Content value) {
                return value.getContent().length;
            }
        };
    }

    private void scheduleCleanups() {
        if (this.scheduledExecSvc != null) {
            this.futureScheduledCleanups = this.scheduledExecSvc.scheduleAtFixedRate(this.periodicCleanupRunnable, this.config.cleanupIntervalSec, this.config.cleanupIntervalSec, TimeUnit.SECONDS);
        }
    }

    void start() {
        this.scheduleCleanups();
    }

    void stop() {
        if (this.futureScheduledCleanups != null) {
            this.futureScheduledCleanups.cancel(false);
            this.futureScheduledCleanups = null;
        }
        this.contentCache.invalidateAll();
        this.perSessionCounterCache.invalidateAll();
    }
}

