/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerSessionItemCounter {
    private static final Logger LOG = LoggerFactory.getLogger(PerSessionItemCounter.class);
    private final int maxSessionCount;
    private final LoadingCache<String, AtomicInteger> perSessionCounterCache;

    public PerSessionItemCounter(int maxSessionCount, LoadingCache<String, AtomicInteger> perSessionCounterCache) {
        this.maxSessionCount = maxSessionCount;
        this.perSessionCounterCache = perSessionCounterCache;
    }

    public void increment(String sessionID) {
        try {
            AtomicInteger counter = (AtomicInteger)this.perSessionCounterCache.get((Object)sessionID);
            int current = counter.incrementAndGet();
            if (current > this.maxSessionCount) {
                counter.decrementAndGet();
                throw new TooManyException();
            }
        }
        catch (ExecutionException e) {
            LOG.error("exception created cache element", e.getCause());
        }
    }

    public void decrement(String sessionID) {
        AtomicInteger counter = (AtomicInteger)this.perSessionCounterCache.getIfPresent((Object)sessionID);
        if (counter != null) {
            counter.decrementAndGet();
        }
    }

    public static class TooManyException
    extends RuntimeException {
        public TooManyException() {
            super("per-session count exceeded");
        }
    }
}

