/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache;

import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;

public class SizeLimitedInputStreamFilter
extends CountingInputStream {
    private final long sizeLimit;

    public SizeLimitedInputStreamFilter(long sizeLimit, InputStream in) {
        super(in);
        this.sizeLimit = sizeLimit;
    }

    protected synchronized void afterRead(int n) {
        if (this.getByteCount() + (long)n > this.sizeLimit) {
            throw new TooBigException(this.sizeLimit);
        }
        super.afterRead(n);
    }

    static class TooBigException
    extends RuntimeException {
        public TooBigException(long size) {
            super("input exceeds size limit: " + size);
        }
    }
}

