/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache.config;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.content.echocache.config.DynamicConfigSource;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import java.util.function.Supplier;

public class DynamicConfigSourceFromCPF
implements DynamicConfigSource {
    private final ConfigurationPropertyFactory cpf;

    public DynamicConfigSourceFromCPF(ConfigurationPropertyFactory configPropFactory) {
        this.cpf = configPropFactory;
    }

    @Override
    public Supplier<Integer> getIntProperty(String name, int defaultValue, Runnable onChangeCallback) {
        final DynamicIntProperty intProp = this.cpf.getIntProperty(name, defaultValue, onChangeCallback);
        return new Supplier<Integer>(){

            @Override
            public Integer get() {
                return intProp.getValue();
            }
        };
    }

    @Override
    public Supplier<Long> getLongProperty(String name, long defaultValue, Runnable onChangeCallback) {
        final DynamicLongProperty longProp = this.cpf.getLongProperty(name, defaultValue, onChangeCallback);
        return new Supplier<Long>(){

            @Override
            public Long get() {
                return longProp.getValue();
            }
        };
    }
}

