/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache.config;

public class EchoServiceConfiguration {
    public static final EchoServiceConfiguration DEFAULT = new EchoServiceConfiguration();
    public long itemSizeLimit;
    public long overallSizeLimitMB;
    public int echoCacheExpirySec;
    public int maxItemsPerSession;
    public int maxCachedSessionCounters;
    public int cleanupIntervalSec;

    public String toString() {
        return super.toString() + String.format("item size limit (bytes): %d, total size (MB): %d, expiry (sec): %d, maxItemsPerSession: %d, max session counters: %d, cleanup interval (s): %d:", this.itemSizeLimit, this.overallSizeLimitMB, this.echoCacheExpirySec, this.maxItemsPerSession, this.maxCachedSessionCounters, this.cleanupIntervalSec);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cleanupIntervalSec;
        result = 31 * result + this.echoCacheExpirySec;
        result = 31 * result + (int)(this.itemSizeLimit ^ this.itemSizeLimit >>> 32);
        result = 31 * result + this.maxCachedSessionCounters;
        result = 31 * result + this.maxItemsPerSession;
        result = 31 * result + (int)(this.overallSizeLimitMB ^ this.overallSizeLimitMB >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EchoServiceConfiguration other = (EchoServiceConfiguration)obj;
        if (this.cleanupIntervalSec != other.cleanupIntervalSec) {
            return false;
        }
        if (this.echoCacheExpirySec != other.echoCacheExpirySec) {
            return false;
        }
        if (this.itemSizeLimit != other.itemSizeLimit) {
            return false;
        }
        if (this.maxCachedSessionCounters != other.maxCachedSessionCounters) {
            return false;
        }
        if (this.maxItemsPerSession != other.maxItemsPerSession) {
            return false;
        }
        return this.overallSizeLimitMB == other.overallSizeLimitMB;
    }

    static {
        EchoServiceConfiguration.DEFAULT.itemSizeLimit = 0x100000L;
        EchoServiceConfiguration.DEFAULT.overallSizeLimitMB = 100L;
        EchoServiceConfiguration.DEFAULT.echoCacheExpirySec = 30;
        EchoServiceConfiguration.DEFAULT.maxItemsPerSession = 50;
        EchoServiceConfiguration.DEFAULT.maxCachedSessionCounters = 100000;
        EchoServiceConfiguration.DEFAULT.cleanupIntervalSec = 60;
    }
}

