/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.echocache.config;

import com.google.common.eventbus.EventBus;
import com.ibm.bi.content.echocache.config.DynamicConfigSource;
import com.ibm.bi.content.echocache.config.EchoServiceConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoServiceConfigurationController {
    private static final Logger LOG = LoggerFactory.getLogger(EchoServiceConfigurationController.class);
    private Supplier<Long> itemSizeLimit;
    private Supplier<Long> overallSizeLimitMB;
    private Supplier<Integer> echoCacheExpirySec;
    private Supplier<Integer> maxItemsPerSession;
    private Supplier<Integer> maxCachedSessionCounters;
    private Supplier<Integer> cleanupIntervalSec;
    private AtomicBoolean notificationsEnabled = new AtomicBoolean(true);
    private final EventBus eventBus;
    private WhenConfigChanges whenConfigChanges = new WhenConfigChanges();

    public EchoServiceConfigurationController(DynamicConfigSource configSource, EventBus eventBus) {
        this.eventBus = eventBus;
        EchoServiceConfiguration def = EchoServiceConfiguration.DEFAULT;
        this.itemSizeLimit = configSource.getLongProperty("Content_Service.echoCacheItemSizeLimitBytes", def.itemSizeLimit, this.whenConfigChanges);
        this.overallSizeLimitMB = configSource.getLongProperty("Content_Service.echoCacheOverallSizeLimitMB", def.overallSizeLimitMB, this.whenConfigChanges);
        this.echoCacheExpirySec = configSource.getIntProperty("Content_Service.echoCacheExpirySec", def.echoCacheExpirySec, this.whenConfigChanges);
        this.maxItemsPerSession = configSource.getIntProperty("Content_Service.echoCacheMaxItemsPerSession", def.maxItemsPerSession, this.whenConfigChanges);
        this.maxCachedSessionCounters = configSource.getIntProperty("Content_Service.echoCacheMaxCachedSessionCounters", def.maxCachedSessionCounters, this.whenConfigChanges);
        this.cleanupIntervalSec = configSource.getIntProperty("Content_Service.echoCacheCleanupIntervalSec", def.cleanupIntervalSec, this.whenConfigChanges);
        this.whenConfigChanges.run();
    }

    public EchoServiceConfiguration loadConfiguration() {
        EchoServiceConfiguration cfg = new EchoServiceConfiguration();
        cfg.itemSizeLimit = this.itemSizeLimit.get();
        cfg.overallSizeLimitMB = this.overallSizeLimitMB.get();
        cfg.echoCacheExpirySec = this.echoCacheExpirySec.get();
        cfg.maxItemsPerSession = this.maxItemsPerSession.get();
        cfg.maxCachedSessionCounters = this.maxCachedSessionCounters.get();
        cfg.cleanupIntervalSec = this.cleanupIntervalSec.get();
        if (LOG.isDebugEnabled()) {
            LOG.debug("loaded configuration: " + cfg.toString());
        }
        return cfg;
    }

    public void enableNotifications(boolean enable) {
        this.notificationsEnabled.set(enable);
    }

    private class WhenConfigChanges
    implements Runnable {
        private WhenConfigChanges() {
        }

        @Override
        public void run() {
            if (EchoServiceConfigurationController.this.notificationsEnabled.get()) {
                EchoServiceConfigurationController.this.eventBus.post((Object)new ConfigChange());
            }
        }
    }

    public static class ConfigChange {
    }
}

