/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.Parameter;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.xml.Namespace;
import java.util.Collection;
import java.util.LinkedHashMap;

public class Method {
    private final String name;
    private final Namespace namespace;
    private String soapAction;
    private LinkedHashMap<String, Parameter> params = new LinkedHashMap();
    private String[] paramNames;
    private int requiredParams;
    private Type returnType;

    public Method(String name, Namespace ns, String soapAction) {
        this.name = name;
        this.namespace = ns;
        this.soapAction = soapAction;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void addParameter(String name, Type t, boolean required) {
        this.params.put(name, new Parameter(name, t, this.params.size(), required));
        if (required) {
            ++this.requiredParams;
        }
    }

    public Collection<Parameter> parameters() {
        return this.params.values();
    }

    public Parameter getParameter(String name) {
        return this.params.get(name);
    }

    public String[] getParameterNames() {
        if (this.paramNames == null) {
            String[] result = new String[this.params.size()];
            int i = 0;
            for (Parameter p : this.params.values()) {
                result[i++] = p.getName();
            }
            this.paramNames = result;
        }
        return this.paramNames;
    }

    public int getRequiredParameters() {
        return this.requiredParams;
    }

    public void setReturnType(Type t) {
        this.returnType = t;
    }

    public Type getReturnType() {
        return this.returnType;
    }
}

