/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema.handlers;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.handlers.MetaHelper;
import com.ibm.bi.soap.schema.handlers.PropEnumHandler;
import com.ibm.bi.soap.schema.handlers.StructHandler;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class BaseClassHandler
extends StructHandler {
    public static final String TYPE_PROPERTY = "type";

    @Override
    public Object deserialize(DeserializationContext dc, Type type) throws XMLStreamException {
        Object obj = super.deserialize(dc, type = dc.getElementType(type));
        if (dc.json.isNull(obj)) {
            return obj;
        }
        Map result = (Map)obj;
        this.mapPropertyNames(dc.json, result, true);
        result.put(dc.json.createString(TYPE_PROPERTY), dc.json.createString(type.getName()));
        this.createLinks(dc, result, type);
        return obj;
    }

    private void mapPropertyNames(JsonFactory json, Map result, boolean toRest) {
        ArrayList<Object> renamed = new ArrayList<Object>();
        for (Map.Entry entry : result.entrySet()) {
            String propName = json.toString(entry.getKey());
            String mappedName = PropEnumHandler.mapProperty(propName, toRest);
            if (mappedName == null) continue;
            renamed.add(entry.getKey());
            renamed.add(json.createString(mappedName));
        }
        for (int i = 0; i < renamed.size(); i += 2) {
            Object value = result.remove(renamed.get(i));
            result.put(renamed.get(i + 1), value);
        }
    }

    private void createLinks(DeserializationContext dc, Map obj, Type type) {
        Object jsStoreID = obj.get(dc.json.createString("id"));
        if (dc.json.isNull(jsStoreID)) {
            return;
        }
        Object jsSearchPath = obj.get(dc.json.createString("searchPath"));
        MetaHelper metaHelper = new MetaHelper(dc.json);
        metaHelper.createLinks(obj, type.getName(), jsStoreID, dc.baseURL, jsSearchPath);
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Type type, Object value) {
        if (sc.json.isNull(value)) {
            super.serialize(sc, tag, type, value);
            return;
        }
        Map item = (Map)value;
        Object otype = item.remove(sc.json.createString(TYPE_PROPERTY));
        if (!sc.json.isNull(otype)) {
            String stype = sc.json.toString(otype);
            Type t = sc.getType("xsd", stype);
            if (t == null) {
                t = sc.getType("bus", stype);
            }
            if (t != null && t.isSubclassOf(type)) {
                this.mapPropertyNames(sc.json, item, false);
                super.serialize(sc, tag, t, value);
            }
        }
    }
}

