/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.http;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.client.cache.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIHttpClientCache
implements HttpCacheStorage {
    private static Logger logger = null;
    public static int maxVariants = Integer.getInteger("BIHttpClientCache.maxVariants", 100);
    public static int maxCacheEntries = Integer.getInteger("BIHttpClientCache.maxCacheEntries", 500);
    public static long maxCacheObjectSize = Long.getLong("BIHttpClientCache.maxCacheObjectSize", 8192L);
    private String context = null;
    static Map<String, HttpCacheEntry> cache = Collections.synchronizedMap(new LinkedHashMap<String, HttpCacheEntry>(maxCacheEntries){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, HttpCacheEntry> eldest) {
            logger.debug("entries in cache: {}", (Object)this.size());
            return this.size() > maxCacheEntries;
        }
    });

    public BIHttpClientCache() {
    }

    public BIHttpClientCache(String context) {
        this.context = context;
    }

    BIHttpClientCache(int entries, int size) {
        maxCacheEntries = entries;
        maxCacheObjectSize = size;
    }

    public HttpCacheEntry getEntry(String key) throws IOException {
        if (StringUtils.isNotEmpty((String)key)) {
            HttpCacheEntry entry = cache.get(key);
            this.getLogger().debug(entry != null ? "got entry {}" : "missed entry {}", (Object)key);
            return entry;
        }
        return null;
    }

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        if (StringUtils.isNotEmpty((String)key)) {
            if (this.getLogger().isDebugEnabled()) {
                Resource r = entry.getResource();
                this.getLogger().debug("put {}, size: {}", (Object)key, r != null ? Long.valueOf(r.length()) : "unknown");
            }
            if (!this.tooBig(entry)) {
                cache.put(key, entry);
            }
        }
    }

    private boolean tooBig(HttpCacheEntry entry) {
        if (entry.hasVariants() && entry.getVariantMap().size() > maxVariants) {
            this.getLogger().debug("{} has more than {} variants, not cached", (Object)entry.toString(), (Object)maxVariants);
            return true;
        }
        Resource resource = entry.getResource();
        if (resource != null && resource.length() > maxCacheObjectSize) {
            this.getLogger().debug("{} is too big ({}), not cached", (Object)entry.toString(), (Object)resource.length());
            return true;
        }
        return false;
    }

    public void removeEntry(String key) throws IOException {
        if (StringUtils.isNotEmpty((String)key)) {
            Resource resource;
            this.getLogger().debug("remove {}", (Object)key);
            HttpCacheEntry entry = cache.remove(key);
            if (entry != null && (resource = entry.getResource()) != null) {
                resource.dispose();
            }
        }
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        if (StringUtils.isNotEmpty((String)key)) {
            HttpCacheEntry updated = callback.update(cache.get(key));
            this.getLogger().debug("updating {}", (Object)key);
            cache.put(key, updated);
        }
    }

    private Logger getLogger() {
        if (logger == null) {
            logger = LoggerFactory.getLogger((String)(BIHttpClientCache.class.getName() + (this.context != null ? "." + this.context : "")));
        }
        return logger;
    }
}

