/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.model;

import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.services.s3.model.PartETag;
import com.ibm.cloud.objectstorage.services.s3.model.UploadPartResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CompleteMultipartUploadRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String bucketName;
    private String key;
    private String uploadId;
    private List<PartETag> partETags = new ArrayList<PartETag>();
    private Date retentionExpirationDate;
    private String retentionLegalHoldId;
    private Long retentionPeriod;
    private boolean isRequesterPays;

    public CompleteMultipartUploadRequest() {
    }

    public CompleteMultipartUploadRequest(String bucketName, String key, String uploadId, List<PartETag> partETags) {
        this.bucketName = bucketName;
        this.key = key;
        this.uploadId = uploadId;
        this.partETags = partETags;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public CompleteMultipartUploadRequest withBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CompleteMultipartUploadRequest withKey(String key) {
        this.key = key;
        return this;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public CompleteMultipartUploadRequest withUploadId(String uploadId) {
        this.uploadId = uploadId;
        return this;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public void setPartETags(List<PartETag> partETags) {
        this.partETags = partETags;
    }

    public CompleteMultipartUploadRequest withPartETags(List<PartETag> partETags) {
        this.setPartETags(partETags);
        return this;
    }

    public CompleteMultipartUploadRequest withPartETags(UploadPartResult ... uploadPartResults) {
        for (UploadPartResult result : uploadPartResults) {
            this.partETags.add(new PartETag(result.getPartNumber(), result.getETag()));
        }
        return this;
    }

    public CompleteMultipartUploadRequest withPartETags(Collection<UploadPartResult> uploadPartResultsCollection) {
        for (UploadPartResult result : uploadPartResultsCollection) {
            this.partETags.add(new PartETag(result.getPartNumber(), result.getETag()));
        }
        return this;
    }

    public Date getRetentionExpirationDate() {
        return this.retentionExpirationDate;
    }

    public void setRetentionExpirationDate(Date retentionExpirationDate) {
        this.retentionExpirationDate = retentionExpirationDate;
    }

    public CompleteMultipartUploadRequest withRetentionExpirationDate(Date retentionExpirationDate) {
        this.retentionExpirationDate = retentionExpirationDate;
        return this;
    }

    public String getRetentionLegalHoldId() {
        return this.retentionLegalHoldId;
    }

    public void setRetentionLegalHoldId(String retentionLegalHoldId) {
        this.retentionLegalHoldId = retentionLegalHoldId;
    }

    public CompleteMultipartUploadRequest withRetentionLegalHoldId(String retentionLegalHoldId) {
        this.retentionLegalHoldId = retentionLegalHoldId;
        return this;
    }

    public Long getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    public CompleteMultipartUploadRequest withRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean isRequesterPays) {
        this.isRequesterPays = isRequesterPays;
    }

    public CompleteMultipartUploadRequest withRequesterPays(boolean isRequesterPays) {
        this.setRequesterPays(isRequesterPays);
        return this;
    }
}

