/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.restful;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathParser.class);
    private static final HashMap<String, String> sequences = new HashMap();

    private PathParser() {
    }

    public static String parseSearchPathIntoPath(String searchPath) {
        StringBuilder path = null;
        int index = -1;
        for (Map.Entry<String, String> entry : sequences.entrySet()) {
            String sequence = entry.getKey();
            if (!searchPath.startsWith(sequence)) continue;
            index = PathParser.getAfterSequenceIndex(searchPath, sequence);
            if (index <= -1) break;
            path = new StringBuilder();
            path.append(PathParser.urlEncode(sequences.get(sequence)));
            break;
        }
        if (path == null) {
            return null;
        }
        int firstQuoteIndex = PathParser.getNextQuoteIndex(searchPath, index);
        while (firstQuoteIndex > -1) {
            int secondQuoteIndex = PathParser.getNextQuoteIndex(searchPath, firstQuoteIndex + 1);
            while (PathParser.isInternalQuote(searchPath, firstQuoteIndex, secondQuoteIndex)) {
                searchPath = PathParser.unescapeInternalQuote(searchPath, firstQuoteIndex, secondQuoteIndex);
                secondQuoteIndex = PathParser.getNextQuoteIndex(searchPath, secondQuoteIndex + 1);
            }
            String name = searchPath.substring(firstQuoteIndex + 1, secondQuoteIndex);
            path.append("/");
            path.append(PathParser.urlEncode(name));
            firstQuoteIndex = PathParser.getNextQuoteIndex(searchPath, ++secondQuoteIndex);
        }
        return PathParser.urlEncode(path.toString()).replaceAll("\\+", "%20");
    }

    private static int getAfterSequenceIndex(String searchPath, String sequence) {
        int index = sequence.length();
        if ("CAMID".equals(sequence)) {
            index = searchPath.indexOf("/folder");
            if (index < 0) {
                return -1;
            }
            if ((index = PathParser.getNextQuoteIndex(searchPath, index)) > 0) {
                int secondQuoteIndex = PathParser.getNextQuoteIndex(searchPath, index + 1);
                while (PathParser.isInternalQuote(searchPath, index, secondQuoteIndex)) {
                    searchPath = PathParser.unescapeInternalQuote(searchPath, index, secondQuoteIndex);
                    secondQuoteIndex = PathParser.getNextQuoteIndex(searchPath, secondQuoteIndex + 2);
                }
                index = secondQuoteIndex + 1;
            }
        }
        return index;
    }

    private static int getNextQuoteIndex(String searchPath, int start) {
        int index = -1;
        int singleQuote = searchPath.indexOf(39, start);
        int doubleQuote = searchPath.indexOf(34, start);
        if (singleQuote > -1 && doubleQuote > -1) {
            index = singleQuote < doubleQuote ? singleQuote : doubleQuote;
        } else if (singleQuote > -1) {
            index = singleQuote;
        } else if (doubleQuote > -1) {
            index = doubleQuote;
        }
        return index;
    }

    private static boolean isInternalQuote(String searchPath, int first, int second) {
        return searchPath.charAt(first) != searchPath.charAt(second) || searchPath.charAt(second) == searchPath.charAt(second + 1);
    }

    private static boolean isInternalDoubleEscapedQuote(String searchPath, int first, int second) {
        return searchPath.charAt(first) == searchPath.charAt(second) && searchPath.charAt(second) == searchPath.charAt(second + 1);
    }

    private static String unescapeInternalQuote(String s, int first, int second) {
        if (PathParser.isInternalDoubleEscapedQuote(s, first, second)) {
            return s.substring(0, second) + s.substring(second + 1);
        }
        return s;
    }

    private static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Error URL encoding " + s, (Throwable)e);
            return s;
        }
    }

    static {
        sequences.put("/content", ".public_folders");
        sequences.put("/catalog", ".library");
        sequences.put("CAMID", ".my_folders");
    }
}

