/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.services.MimeAttachment;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;

public class HttpEntityBuilder {
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_ID = "Content-Id";

    public HttpEntity createHttpEntity(InputStream is) {
        return new InputStreamEntity(is);
    }

    public HttpEntity createHttpEntity(InputStream is, List<MimeAttachment> attachments, String mimeBoundary) {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT, mimeBoundary, Charset.forName("UTF-8"));
        this.addMessageBody(entity, is);
        for (MimeAttachment attachment : attachments) {
            this.addAttachment(entity, attachment);
        }
        return entity;
    }

    private void addMessageBody(MultipartEntity entity, InputStream is) {
        entity.addPart(this.createMessageBody(is));
    }

    private FormBodyPart createMessageBody(InputStream is) {
        InputStreamBody isb = new InputStreamBody(is, ContentType.TEXT_XML);
        FormBodyPart fbp = new FormBodyPart("soap", (ContentBody)isb);
        fbp.getHeader().removeFields(CONTENT_TRANSFER_ENCODING);
        fbp.getHeader().removeFields(CONTENT_DISPOSITION);
        fbp.getHeader().removeFields(CONTENT_TYPE);
        fbp.addField(CONTENT_TYPE, "text/xml; charset=UTF-8");
        return fbp;
    }

    private void addAttachment(MultipartEntity entity, MimeAttachment attachment) {
        entity.addPart(this.createAttachmentBody(attachment));
    }

    private FormBodyPart createAttachmentBody(MimeAttachment attachment) {
        InputStreamBody isb = new InputStreamBody(attachment.getInputStream(), ContentType.TEXT_PLAIN);
        FormBodyPart fbp = new FormBodyPart("form_body_name", (ContentBody)isb);
        fbp.getHeader().removeFields(CONTENT_DISPOSITION);
        fbp.getHeader().removeFields(CONTENT_TYPE);
        fbp.addField(CONTENT_TYPE, attachment.getContentType());
        fbp.addField(CONTENT_ID, "<" + attachment.getContentId() + ">");
        return fbp;
    }
}

