/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SoftCache;
import com.ibm.icu.impl.TimeZoneGenericNames;
import com.ibm.icu.impl.ZoneMeta;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.text.TimeZoneNames;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZoneFormat
extends UFormat
implements Freezable<TimeZoneFormat>,
Serializable {
    private static final long serialVersionUID = 2281246852693575022L;
    private ULocale _locale;
    private TimeZoneNames _tznames;
    private volatile TimeZoneGenericNames _gnames;
    private String _gmtPattern;
    private String[] _gmtOffsetPatterns;
    private String[] _gmtOffsetDigits;
    private String _gmtZeroFormat;
    private boolean _parseAllStyles;
    private transient String[] _gmtPatternTokens;
    private transient Object[][] _gmtOffsetPatternItems;
    private transient String _region;
    private transient boolean _frozen;
    private static final String TZID_GMT = "Etc/GMT";
    private static final String[] ALT_GMT_STRINGS = new String[]{"GMT", "UTC", "UT"};
    private static final String DEFAULT_GMT_PATTERN = "GMT{0}";
    private static final String DEFAULT_GMT_ZERO = "GMT";
    private static final String[] DEFAULT_GMT_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final char DEFAULT_GMT_OFFSET_SEP = ':';
    private static final String RFC822_DIGITS = "0123456789";
    private static final GMTOffsetPatternType[] PARSE_GMT_OFFSET_TYPES = new GMTOffsetPatternType[]{GMTOffsetPatternType.POSITIVE_HMS, GMTOffsetPatternType.NEGATIVE_HMS, GMTOffsetPatternType.POSITIVE_HM, GMTOffsetPatternType.NEGATIVE_HM};
    private static final int MAX_OFFSET_HOUR = 23;
    private static final int MAX_OFFSET_MINUTE = 59;
    private static final int MAX_OFFSET_SECOND = 59;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_SECOND = 1000;
    private static TimeZoneFormatCache _tzfCache = new TimeZoneFormatCache();
    private static final EnumSet<TimeZoneNames.NameType> ALL_SPECIFIC_NAME_TYPES = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, new TimeZoneNames.NameType[]{TimeZoneNames.NameType.LONG_DAYLIGHT, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, TimeZoneNames.NameType.SHORT_STANDARD_COMMONLY_USED, TimeZoneNames.NameType.SHORT_DAYLIGHT_COMMONLY_USED});
    private static final EnumSet<TimeZoneGenericNames.GenericNameType> ALL_GENERIC_NAME_TYPES = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION, TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.SHORT);

    protected TimeZoneFormat(ULocale locale) {
        this._locale = locale;
        this._tznames = TimeZoneNames.getInstance(locale);
        String gmtPattern = null;
        String hourFormats = null;
        this._gmtZeroFormat = DEFAULT_GMT_ZERO;
        try {
            ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt48b/zone", locale);
            try {
                gmtPattern = bundle.getStringWithFallback("zoneStrings/gmtFormat");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                hourFormats = bundle.getStringWithFallback("zoneStrings/hourFormat");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                this._gmtZeroFormat = bundle.getStringWithFallback("zoneStrings/gmtZeroFormat");
            }
            catch (MissingResourceException e) {}
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (gmtPattern == null) {
            gmtPattern = DEFAULT_GMT_PATTERN;
        }
        this.initGMTPattern(gmtPattern);
        String[] gmtOffsetPatterns = new String[GMTOffsetPatternType.values().length];
        if (hourFormats != null) {
            String[] hourPatterns = hourFormats.split(";", 2);
            gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HM.ordinal()] = hourPatterns[0];
            gmtOffsetPatterns[GMTOffsetPatternType.POSITIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern(hourPatterns[0]);
            gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] = hourPatterns[1];
            gmtOffsetPatterns[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()] = TimeZoneFormat.expandOffsetPattern(hourPatterns[1]);
        } else {
            for (GMTOffsetPatternType patType : GMTOffsetPatternType.values()) {
                gmtOffsetPatterns[patType.ordinal()] = patType.defaultPattern();
            }
        }
        this.initGMTOffsetPatterns(gmtOffsetPatterns);
        this._gmtOffsetDigits = DEFAULT_GMT_DIGITS;
        NumberingSystem ns = NumberingSystem.getInstance(locale);
        if (!ns.isAlgorithmic()) {
            this._gmtOffsetDigits = TimeZoneFormat.toCodePoints(ns.getDescription());
        }
    }

    public static TimeZoneFormat getInstance(ULocale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        return (TimeZoneFormat)_tzfCache.getInstance(locale, locale);
    }

    public TimeZoneNames getTimeZoneNames() {
        return this._tznames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeZoneGenericNames getTimeZoneGenericNames() {
        if (this._gnames == null) {
            TimeZoneFormat timeZoneFormat = this;
            synchronized (timeZoneFormat) {
                if (this._gnames == null) {
                    this._gnames = TimeZoneGenericNames.getInstance(this._locale);
                }
            }
        }
        return this._gnames;
    }

    public TimeZoneFormat setTimeZoneNames(TimeZoneNames tznames) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this._tznames = tznames;
        this._gnames = new TimeZoneGenericNames(this._locale, this._tznames);
        return this;
    }

    public String getGMTPattern() {
        return this._gmtPattern;
    }

    public TimeZoneFormat setGMTPattern(String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.initGMTPattern(pattern);
        return this;
    }

    public String getGMTOffsetPattern(GMTOffsetPatternType type) {
        return this._gmtOffsetPatterns[type.ordinal()];
    }

    public TimeZoneFormat setGMTOffsetPattern(GMTOffsetPatternType type, String pattern) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (pattern == null) {
            throw new NullPointerException("Null GMT offset pattern");
        }
        Object[] parsedItems = TimeZoneFormat.parseOffsetPattern(pattern, type.required());
        this._gmtOffsetPatterns[type.ordinal()] = pattern;
        this._gmtOffsetPatternItems[type.ordinal()] = parsedItems;
        return this;
    }

    public String getGMTOffsetDigits() {
        StringBuilder buf = new StringBuilder(this._gmtOffsetDigits.length);
        for (String digit : this._gmtOffsetDigits) {
            buf.append(digit);
        }
        return buf.toString();
    }

    public TimeZoneFormat setGMTOffsetDigits(String digits) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (digits == null) {
            throw new NullPointerException("Null GMT offset digits");
        }
        String[] digitArray = TimeZoneFormat.toCodePoints(digits);
        if (digitArray.length != 10) {
            throw new IllegalArgumentException("Length of digits must be 10");
        }
        this._gmtOffsetDigits = digitArray;
        return this;
    }

    public String getGMTZeroFormat() {
        return this._gmtZeroFormat;
    }

    public TimeZoneFormat setGMTZeroFormat(String gmtZeroFormat) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (gmtZeroFormat == null) {
            throw new NullPointerException("Null GMT zero format");
        }
        if (gmtZeroFormat.length() == 0) {
            throw new IllegalArgumentException("Empty GMT zero format");
        }
        this._gmtZeroFormat = gmtZeroFormat;
        return this;
    }

    public boolean isParseAllStyles() {
        return this._parseAllStyles;
    }

    public TimeZoneFormat setParseAllStyles(boolean parseAllStyles) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this._parseAllStyles = parseAllStyles;
        return this;
    }

    public final String formatOffsetRFC822(int offset) {
        StringBuilder buf = new StringBuilder();
        char sign = '+';
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        }
        buf.append(sign);
        int offsetH = offset / 3600000;
        int offsetM = (offset %= 3600000) / 60000;
        int offsetS = (offset %= 60000) / 1000;
        assert (offsetH >= 0 && offsetH < 100);
        assert (offsetM >= 0 && offsetM < 60);
        assert (offsetS >= 0 && offsetS < 60);
        int num = 0;
        int denom = 0;
        if (offsetS == 0) {
            offset = offsetH * 100 + offsetM;
            num = offset % 10000;
            denom = 1000;
        } else {
            offset = offsetH * 10000 + offsetM * 100 + offsetS;
            num = offset % 1000000;
            denom = 100000;
        }
        while (denom >= 1) {
            char digit = (char)(num / denom + 48);
            buf.append(digit);
            num %= denom;
            denom /= 10;
        }
        return buf.toString();
    }

    public String formatOffsetLocalizedGMT(int offset) {
        if (offset == 0) {
            return this._gmtZeroFormat;
        }
        StringBuilder buf = new StringBuilder();
        boolean positive = true;
        if (offset < 0) {
            offset = -offset;
            positive = false;
        }
        int offsetH = offset / 3600000;
        int offsetM = (offset %= 3600000) / 60000;
        int offsetS = (offset %= 60000) / 1000;
        if (offsetH > 23 || offsetM > 59 || offsetS > 59) {
            throw new IllegalArgumentException("Offset out of range :" + offset);
        }
        Object[] offsetPatternItems = positive ? (offsetS == 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.POSITIVE_HMS.ordinal()]) : (offsetS == 0 ? this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HM.ordinal()] : this._gmtOffsetPatternItems[GMTOffsetPatternType.NEGATIVE_HMS.ordinal()]);
        buf.append(this._gmtPatternTokens[0]);
        block5: for (Object item : offsetPatternItems) {
            if (item instanceof String) {
                buf.append((String)item);
                continue;
            }
            if (!(item instanceof GMTOffsetField)) continue;
            GMTOffsetField field = (GMTOffsetField)item;
            switch (field.getType()) {
                case 'H': {
                    this.appendOffsetDigits(buf, offsetH, field.getWidth());
                    continue block5;
                }
                case 'm': {
                    this.appendOffsetDigits(buf, offsetM, field.getWidth());
                    continue block5;
                }
                case 's': {
                    this.appendOffsetDigits(buf, offsetS, field.getWidth());
                }
            }
        }
        buf.append(this._gmtPatternTokens[1]);
        return buf.toString();
    }

    public final String format(Style style, TimeZone tz, long date) {
        return this.format(style, tz, date, null);
    }

    public String format(Style style, TimeZone tz, long date, Output<TimeType> timeType) {
        String result = null;
        if (timeType != null) {
            timeType.value = TimeType.UNKNOWN;
        }
        switch (style) {
            case GENERIC_LOCATION: {
                result = this.getTimeZoneGenericNames().getGenericLocationName(ZoneMeta.getCanonicalCLDRID(tz));
                break;
            }
            case GENERIC_LONG: {
                result = this.getTimeZoneGenericNames().getDisplayName(tz, TimeZoneGenericNames.GenericNameType.LONG, date);
                break;
            }
            case GENERIC_SHORT: {
                result = this.getTimeZoneGenericNames().getDisplayName(tz, TimeZoneGenericNames.GenericNameType.SHORT, date);
                break;
            }
            case SPECIFIC_LONG: {
                result = this.formatSpecific(tz, TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, date, timeType);
                break;
            }
            case SPECIFIC_SHORT: {
                result = this.formatSpecific(tz, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT, date, timeType);
                break;
            }
            case SPECIFIC_SHORT_COMMONLY_USED: {
                result = this.formatSpecific(tz, TimeZoneNames.NameType.SHORT_STANDARD_COMMONLY_USED, TimeZoneNames.NameType.SHORT_DAYLIGHT_COMMONLY_USED, date, timeType);
                break;
            }
        }
        if (result == null) {
            int[] offsets = new int[]{0, 0};
            tz.getOffset(date, false, offsets);
            result = style == Style.RFC822 ? this.formatOffsetRFC822(offsets[0] + offsets[1]) : this.formatOffsetLocalizedGMT(offsets[0] + offsets[1]);
            if (timeType != null) {
                TimeType timeType2 = timeType.value = offsets[1] != 0 ? TimeType.DAYLIGHT : TimeType.STANDARD;
            }
        }
        assert (result != null);
        return result;
    }

    public final int parseOffsetRFC822(String text, ParsePosition pos) {
        int digit;
        int numDigits;
        int sign;
        int start = pos.getIndex();
        if (start + 2 >= text.length()) {
            pos.setErrorIndex(start);
            return 0;
        }
        char signChar = text.charAt(start);
        if (signChar == '+') {
            sign = 1;
        } else if (signChar == '-') {
            sign = -1;
        } else {
            pos.setErrorIndex(start);
            return 0;
        }
        int idx = start + 1;
        int[] digits = new int[6];
        for (numDigits = 0; numDigits < digits.length && idx < text.length() && (digit = RFC822_DIGITS.indexOf(text.charAt(idx))) >= 0; ++numDigits, ++idx) {
            digits[numDigits] = digit;
        }
        if (numDigits == 0) {
            pos.setErrorIndex(start);
            return 0;
        }
        int hour = 0;
        int min = 0;
        int sec = 0;
        switch (numDigits) {
            case 1: {
                hour = digits[0];
                break;
            }
            case 2: {
                hour = digits[0] * 10 + digits[1];
                break;
            }
            case 3: {
                hour = digits[0];
                min = digits[1] * 10 + digits[2];
                break;
            }
            case 4: {
                hour = digits[0] * 10 + digits[1];
                min = digits[2] * 10 + digits[3];
                break;
            }
            case 5: {
                hour = digits[0];
                min = digits[1] * 10 + digits[2];
                sec = digits[3] * 10 + digits[4];
                break;
            }
            case 6: {
                hour = digits[0] * 10 + digits[1];
                min = digits[2] * 10 + digits[3];
                sec = digits[4] * 10 + digits[5];
            }
        }
        if (hour > 23 || min > 59 || sec > 59) {
            pos.setErrorIndex(start);
            return 0;
        }
        pos.setIndex(start + 1 + numDigits);
        return ((hour * 60 + min) * 60 + sec) * 1000 * sign;
    }

    public int parseOffsetLocalizedGMT(String text, ParsePosition pos) {
        return this.parseOffsetLocalizedGMT(text, pos, null);
    }

    public TimeZone parse(Style style, String text, ParsePosition pos, Output<TimeType> timeType) {
        return this.parse(style, text, pos, this._parseAllStyles, timeType);
    }

    public final TimeZone parse(String text, ParsePosition pos) {
        return this.parse(Style.GENERIC_LOCATION, text, pos, true, null);
    }

    public final TimeZone parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        TimeZone tz = this.parse(text, pos);
        if (pos.getErrorIndex() >= 0) {
            throw new ParseException("Unparseable time zone: \"" + text + "\"", 0);
        }
        assert (tz != null);
        return tz;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        TimeZone tz = null;
        long date = System.currentTimeMillis();
        if (obj instanceof TimeZone) {
            tz = (TimeZone)obj;
        } else if (obj instanceof Calendar) {
            tz = ((Calendar)obj).getTimeZone();
            date = ((Calendar)obj).getTimeInMillis();
        } else {
            throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a time zone");
        }
        assert (tz != null);
        String result = this.formatOffsetLocalizedGMT(tz.getOffset(date));
        toAppendTo.append(result);
        if (pos.getFieldAttribute() == DateFormat.Field.TIME_ZONE || pos.getField() == 17) {
            pos.setBeginIndex(0);
            pos.setEndIndex(result.length());
        }
        return toAppendTo;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        StringBuffer toAppendTo = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        toAppendTo = this.format(obj, toAppendTo, pos);
        AttributedString as = new AttributedString(toAppendTo.toString());
        as.addAttribute(DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE);
        return as.getIterator();
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    private String formatSpecific(TimeZone tz, TimeZoneNames.NameType stdType, TimeZoneNames.NameType dstType, long date, Output<TimeType> timeType) {
        String name;
        assert (stdType == TimeZoneNames.NameType.LONG_STANDARD || stdType == TimeZoneNames.NameType.SHORT_STANDARD || stdType == TimeZoneNames.NameType.SHORT_STANDARD_COMMONLY_USED);
        assert (dstType == TimeZoneNames.NameType.LONG_DAYLIGHT || dstType == TimeZoneNames.NameType.SHORT_DAYLIGHT || dstType == TimeZoneNames.NameType.SHORT_DAYLIGHT_COMMONLY_USED);
        boolean isDaylight = tz.inDaylightTime(new Date(date));
        String string = name = isDaylight ? this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(tz), dstType, date) : this.getTimeZoneNames().getDisplayName(ZoneMeta.getCanonicalCLDRID(tz), stdType, date);
        if (name != null && timeType != null) {
            timeType.value = isDaylight ? TimeType.DAYLIGHT : TimeType.STANDARD;
        }
        return name;
    }

    private TimeZone parse(Style style, String text, ParsePosition pos, boolean parseAllStyles, Output<TimeType> timeType) {
        Collection<TimeZoneNames.MatchInfo> specificMatches;
        if (timeType != null) {
            timeType.value = TimeType.UNKNOWN;
        }
        int startIdx = pos.getIndex();
        ParsePosition tmpPos = new ParsePosition(startIdx);
        int offset = this.parseOffsetRFC822(text, tmpPos);
        if (tmpPos.getErrorIndex() < 0) {
            pos.setIndex(tmpPos.getIndex());
            return this.getTimeZoneForOffset(offset);
        }
        int gmtZeroLen = 0;
        tmpPos.setErrorIndex(-1);
        tmpPos.setIndex(pos.getIndex());
        boolean[] isGMTZero = new boolean[]{false};
        offset = this.parseOffsetLocalizedGMT(text, tmpPos, isGMTZero);
        if (tmpPos.getErrorIndex() < 0) {
            if (!isGMTZero[0] || style == Style.LOCALIZED_GMT || style == Style.RFC822 || tmpPos.getIndex() == text.length()) {
                pos.setIndex(tmpPos.getIndex());
                return this.getTimeZoneForOffset(offset);
            }
            gmtZeroLen = tmpPos.getIndex() - startIdx;
        }
        if (!(parseAllStyles || style != Style.RFC822 && style != Style.LOCALIZED_GMT)) {
            pos.setErrorIndex(pos.getErrorIndex());
            return null;
        }
        if (style == Style.SPECIFIC_LONG || style == Style.SPECIFIC_SHORT || style == Style.SPECIFIC_SHORT_COMMONLY_USED) {
            EnumSet<TimeZoneNames.NameType> nameTypes = null;
            switch (style) {
                case SPECIFIC_LONG: {
                    nameTypes = EnumSet.of(TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT);
                    break;
                }
                case SPECIFIC_SHORT: {
                    nameTypes = EnumSet.of(TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.SHORT_DAYLIGHT);
                    break;
                }
                case SPECIFIC_SHORT_COMMONLY_USED: {
                    nameTypes = EnumSet.of(TimeZoneNames.NameType.SHORT_STANDARD_COMMONLY_USED, TimeZoneNames.NameType.SHORT_DAYLIGHT_COMMONLY_USED);
                }
            }
            specificMatches = this._tznames.find(text, startIdx, nameTypes);
            if (specificMatches != null) {
                int matchLen = 0;
                TimeZoneNames.MatchInfo bestSpecific = null;
                for (TimeZoneNames.MatchInfo match : specificMatches) {
                    if (bestSpecific != null && match.matchLength() <= matchLen) continue;
                    bestSpecific = match;
                    matchLen = match.matchLength();
                }
                if (bestSpecific != null) {
                    if (timeType != null) {
                        timeType.value = this.getTimeType(bestSpecific.nameType());
                    }
                    pos.setIndex(startIdx + bestSpecific.matchLength());
                    return TimeZone.getTimeZone(this.getTimeZoneID(bestSpecific.tzID(), bestSpecific.mzID()));
                }
            }
        } else {
            assert (style == Style.GENERIC_LOCATION || style == Style.GENERIC_LONG || style == Style.GENERIC_SHORT);
            EnumSet<TimeZoneGenericNames.GenericNameType> genericNameTypes = null;
            switch (style) {
                case GENERIC_LOCATION: {
                    genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.LOCATION);
                    break;
                }
                case GENERIC_LONG: {
                    genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.LONG, TimeZoneGenericNames.GenericNameType.LOCATION);
                    break;
                }
                case GENERIC_SHORT: {
                    genericNameTypes = EnumSet.of(TimeZoneGenericNames.GenericNameType.SHORT, TimeZoneGenericNames.GenericNameType.LOCATION);
                }
            }
            TimeZoneGenericNames.GenericMatchInfo bestGeneric = this.getTimeZoneGenericNames().findBestMatch(text, startIdx, genericNameTypes);
            if (bestGeneric != null) {
                if (timeType != null) {
                    timeType.value = bestGeneric.timeType();
                }
                pos.setIndex(startIdx + bestGeneric.matchLength());
                return TimeZone.getTimeZone(bestGeneric.tzID());
            }
        }
        if (gmtZeroLen > 0) {
            pos.setIndex(startIdx + gmtZeroLen);
            return this.getTimeZoneForOffset(0);
        }
        if (parseAllStyles) {
            int maxMatchLength = text.length() - startIdx;
            specificMatches = this._tznames.find(text, startIdx, ALL_SPECIFIC_NAME_TYPES);
            TimeZoneNames.MatchInfo bestSpecific = null;
            if (specificMatches != null) {
                int matchLen = 0;
                for (TimeZoneNames.MatchInfo match : specificMatches) {
                    if (bestSpecific != null && match.matchLength() <= matchLen) continue;
                    bestSpecific = match;
                    matchLen = match.matchLength();
                }
                if (bestSpecific != null && bestSpecific.matchLength() == maxMatchLength) {
                    if (timeType != null) {
                        timeType.value = this.getTimeType(bestSpecific.nameType());
                    }
                    pos.setIndex(startIdx + bestSpecific.matchLength());
                    return TimeZone.getTimeZone(this.getTimeZoneID(bestSpecific.tzID(), bestSpecific.mzID()));
                }
            }
            TimeZoneGenericNames.GenericMatchInfo bestGeneric = this.getTimeZoneGenericNames().findBestMatch(text, startIdx, ALL_GENERIC_NAME_TYPES);
            if (bestSpecific != null || bestGeneric != null) {
                if (bestGeneric == null || bestSpecific != null && bestSpecific.matchLength() > bestGeneric.matchLength()) {
                    if (timeType != null) {
                        timeType.value = this.getTimeType(bestSpecific.nameType());
                    }
                    pos.setIndex(startIdx + bestSpecific.matchLength());
                    return TimeZone.getTimeZone(this.getTimeZoneID(bestSpecific.tzID(), bestSpecific.mzID()));
                }
                if (bestGeneric != null) {
                    if (timeType != null) {
                        timeType.value = bestGeneric.timeType();
                    }
                    pos.setIndex(startIdx + bestGeneric.matchLength());
                    return TimeZone.getTimeZone(bestGeneric.tzID());
                }
            }
        }
        pos.setErrorIndex(startIdx);
        return null;
    }

    private String getTimeZoneID(String tzID, String mzID) {
        String id = tzID;
        if (id == null) {
            assert (mzID != null);
            id = this._tznames.getReferenceZoneID(mzID, this.getTargetRegion());
            if (id == null) {
                throw new IllegalArgumentException("Invalid mzID: " + mzID);
            }
        }
        return id;
    }

    private synchronized String getTargetRegion() {
        if (this._region == null) {
            this._region = this._locale.getCountry();
            if (this._region.length() == 0) {
                ULocale tmp = ULocale.addLikelySubtags(this._locale);
                this._region = tmp.getCountry();
                if (this._region.length() == 0) {
                    this._region = "001";
                }
            }
        }
        return this._region;
    }

    private TimeType getTimeType(TimeZoneNames.NameType nameType) {
        switch (nameType) {
            case LONG_STANDARD: 
            case SHORT_STANDARD: 
            case SHORT_STANDARD_COMMONLY_USED: {
                return TimeType.STANDARD;
            }
            case LONG_DAYLIGHT: 
            case SHORT_DAYLIGHT: 
            case SHORT_DAYLIGHT_COMMONLY_USED: {
                return TimeType.DAYLIGHT;
            }
        }
        return TimeType.UNKNOWN;
    }

    private void initGMTPattern(String gmtPattern) {
        int idx = gmtPattern.indexOf("{0}");
        if (idx < 0) {
            throw new IllegalArgumentException("Bad localized GMT pattern: " + gmtPattern);
        }
        this._gmtPattern = gmtPattern;
        this._gmtPatternTokens = new String[2];
        this._gmtPatternTokens[0] = TimeZoneFormat.unquote(gmtPattern.substring(0, idx));
        this._gmtPatternTokens[1] = TimeZoneFormat.unquote(gmtPattern.substring(idx + 3));
    }

    private static String unquote(String s) {
        if (s.indexOf(39) < 0) {
            return s;
        }
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                if (isPrevQuote) {
                    buf.append(c);
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                }
                inQuote = !inQuote;
                continue;
            }
            isPrevQuote = false;
            buf.append(c);
        }
        return buf.toString();
    }

    private void initGMTOffsetPatterns(String[] gmtOffsetPatterns) {
        int size = GMTOffsetPatternType.values().length;
        if (gmtOffsetPatterns.length < size) {
            throw new IllegalArgumentException("Insufficient number of elements in gmtOffsetPatterns");
        }
        Object[][] gmtOffsetPatternItems = new Object[size][];
        for (GMTOffsetPatternType t : GMTOffsetPatternType.values()) {
            int idx = t.ordinal();
            Object[] parsedItems = TimeZoneFormat.parseOffsetPattern(gmtOffsetPatterns[idx], t.required());
            gmtOffsetPatternItems[idx] = parsedItems;
        }
        this._gmtOffsetPatterns = new String[size];
        System.arraycopy(gmtOffsetPatterns, 0, this._gmtOffsetPatterns, 0, size);
        this._gmtOffsetPatternItems = gmtOffsetPatternItems;
    }

    private static Object[] parseOffsetPattern(String pattern, String letters) {
        boolean isPrevQuote = false;
        boolean inQuote = false;
        StringBuilder text = new StringBuilder();
        char itemType = '\u0000';
        int itemLength = 1;
        boolean invalidPattern = false;
        ArrayList<Object> items = new ArrayList<Object>();
        BitSet checkBits = new BitSet(letters.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                if (isPrevQuote) {
                    text.append('\'');
                    isPrevQuote = false;
                } else {
                    isPrevQuote = true;
                    if (itemType != '\u0000') {
                        if (!GMTOffsetField.isValid(itemType, itemLength)) {
                            invalidPattern = true;
                            break;
                        }
                        items.add(new GMTOffsetField(itemType, itemLength));
                        itemType = '\u0000';
                    }
                }
                inQuote = !inQuote;
                continue;
            }
            isPrevQuote = false;
            if (inQuote) {
                text.append(ch);
                continue;
            }
            int patFieldIdx = letters.indexOf(ch);
            if (patFieldIdx >= 0) {
                if (ch == itemType) {
                    ++itemLength;
                } else {
                    if (itemType == '\u0000') {
                        if (text.length() > 0) {
                            items.add(text.toString());
                            text.setLength(0);
                        }
                    } else if (GMTOffsetField.isValid(itemType, itemLength)) {
                        items.add(new GMTOffsetField(itemType, itemLength));
                    } else {
                        invalidPattern = true;
                        break;
                    }
                    itemType = ch;
                    itemLength = 1;
                }
                checkBits.set(patFieldIdx);
                continue;
            }
            if (itemType != '\u0000') {
                if (!GMTOffsetField.isValid(itemType, itemLength)) {
                    invalidPattern = true;
                    break;
                }
                items.add(new GMTOffsetField(itemType, itemLength));
                itemType = '\u0000';
            }
            text.append(ch);
        }
        if (!invalidPattern) {
            if (itemType == '\u0000') {
                if (text.length() > 0) {
                    items.add(text.toString());
                    text.setLength(0);
                }
            } else if (GMTOffsetField.isValid(itemType, itemLength)) {
                items.add(new GMTOffsetField(itemType, itemLength));
            } else {
                invalidPattern = true;
            }
        }
        if (invalidPattern || checkBits.cardinality() != letters.length()) {
            throw new IllegalStateException("Bad localized GMT offset pattern: " + pattern);
        }
        return items.toArray(new Object[items.size()]);
    }

    private static String expandOffsetPattern(String offsetHM) {
        int idx_mm = offsetHM.indexOf("mm");
        if (idx_mm < 0) {
            return offsetHM + ":ss";
        }
        String sep = ":";
        int idx_H = offsetHM.substring(0, idx_mm).lastIndexOf("H");
        if (idx_H >= 0) {
            sep = offsetHM.substring(idx_H + 1, idx_mm);
        }
        return offsetHM.substring(0, idx_mm + 2) + sep + "ss" + offsetHM.substring(idx_mm + 2);
    }

    private void appendOffsetDigits(StringBuilder buf, int n, int minDigits) {
        assert (n >= 0 && n < 60);
        int numDigits = n >= 10 ? 2 : 1;
        for (int i = 0; i < minDigits - numDigits; ++i) {
            buf.append(this._gmtOffsetDigits[0]);
        }
        if (numDigits == 2) {
            buf.append(this._gmtOffsetDigits[n / 10]);
        }
        buf.append(this._gmtOffsetDigits[n % 10]);
    }

    private TimeZone getTimeZoneForOffset(int offset) {
        if (offset == 0) {
            return TimeZone.getTimeZone(TZID_GMT);
        }
        return ZoneMeta.getCustomTimeZone(offset);
    }

    private int parseOffsetLocalizedGMT(String text, ParsePosition pos, boolean[] isGMTZero) {
        int[] tmpOffset;
        int offsetLen;
        int len;
        int start;
        int idx = start = pos.getIndex();
        boolean parsed = false;
        int offset = 0;
        if (isGMTZero != null && isGMTZero.length > 0) {
            isGMTZero[0] = false;
        }
        if (((len = this._gmtPatternTokens[0].length()) <= 0 || text.regionMatches(true, idx, this._gmtPatternTokens[0], 0, len)) && (offsetLen = this.parseGMTOffset(text, idx += len, false, tmpOffset = new int[1])) != 0) {
            offset = tmpOffset[0];
            len = this._gmtPatternTokens[1].length();
            if (len <= 0 || text.regionMatches(true, idx += offsetLen, this._gmtPatternTokens[1], 0, len)) {
                idx += len;
                parsed = true;
            }
        }
        if (parsed) {
            pos.setIndex(idx);
            return offset;
        }
        int[] parsedLength = new int[]{0};
        offset = this.parseDefaultGMT(text, start, parsedLength);
        if (parsedLength[0] > 0) {
            pos.setIndex(start + parsedLength[0]);
            return offset;
        }
        if (text.regionMatches(true, start, this._gmtZeroFormat, 0, this._gmtZeroFormat.length())) {
            pos.setIndex(start + this._gmtZeroFormat.length());
            if (isGMTZero != null && isGMTZero.length > 0) {
                isGMTZero[0] = true;
            }
            return 0;
        }
        for (String defGMTZero : ALT_GMT_STRINGS) {
            if (!text.regionMatches(true, start, defGMTZero, 0, defGMTZero.length())) continue;
            pos.setIndex(start + defGMTZero.length());
            if (isGMTZero != null && isGMTZero.length > 0) {
                isGMTZero[0] = true;
            }
            return 0;
        }
        pos.setErrorIndex(start);
        return 0;
    }

    private int parseGMTOffset(String text, int start, boolean minimumHourWidth, int[] offset) {
        int parsedLen = 0;
        int[] tmpParsedLen = new int[1];
        offset[0] = 0;
        boolean sawVarHourAndAbuttingField = false;
        for (GMTOffsetPatternType gmtPatType : PARSE_GMT_OFFSET_TYPES) {
            int offsetH = 0;
            int offsetM = 0;
            int offsetS = 0;
            int idx = start;
            Object[] items = this._gmtOffsetPatternItems[gmtPatType.ordinal()];
            boolean failed = false;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] instanceof String) {
                    String patStr = (String)items[i];
                    int len = patStr.length();
                    if (!text.regionMatches(true, idx, patStr, 0, len)) {
                        failed = true;
                        break;
                    }
                    idx += len;
                    continue;
                }
                assert (items[i] instanceof GMTOffsetField);
                GMTOffsetField field = (GMTOffsetField)items[i];
                char fieldType = field.getType();
                if (fieldType == 'H') {
                    int maxDigits;
                    int minDigits = 1;
                    int n = maxDigits = minimumHourWidth ? 1 : 2;
                    if (!minimumHourWidth && !sawVarHourAndAbuttingField && i + 1 < items.length && items[i] instanceof GMTOffsetField) {
                        sawVarHourAndAbuttingField = true;
                    }
                    offsetH = this.parseOffsetDigits(text, idx, minDigits, maxDigits, 0, 23, tmpParsedLen);
                } else if (fieldType == 'm') {
                    offsetM = this.parseOffsetDigits(text, idx, 2, 2, 0, 59, tmpParsedLen);
                } else if (fieldType == 's') {
                    offsetS = this.parseOffsetDigits(text, idx, 2, 2, 0, 59, tmpParsedLen);
                }
                if (tmpParsedLen[0] == 0) {
                    failed = true;
                    break;
                }
                idx += tmpParsedLen[0];
            }
            if (failed) continue;
            int sign = gmtPatType.isPositive() ? 1 : -1;
            offset[0] = ((offsetH * 60 + offsetM) * 60 + offsetS) * 1000 * sign;
            parsedLen = idx - start;
            break;
        }
        if (parsedLen == 0 && sawVarHourAndAbuttingField && !minimumHourWidth) {
            return this.parseGMTOffset(text, start, true, offset);
        }
        return parsedLen;
    }

    private int parseDefaultGMT(String text, int start, int[] parsedLength) {
        int parsed;
        int offset;
        block8: {
            int sign;
            int idx;
            block10: {
                char c;
                block9: {
                    idx = start;
                    offset = 0;
                    parsed = 0;
                    int gmtLen = 0;
                    for (String gmt : ALT_GMT_STRINGS) {
                        int len = gmt.length();
                        if (!text.regionMatches(true, idx, gmt, 0, len)) continue;
                        gmtLen = len;
                        break;
                    }
                    if (gmtLen == 0 || (idx += gmtLen) + 1 >= text.length()) break block8;
                    sign = 1;
                    c = text.charAt(idx);
                    if (c != '+') break block9;
                    sign = 1;
                    break block10;
                }
                if (c != '-') break block8;
                sign = -1;
            }
            int[] lenWithSep = new int[]{0};
            int offsetWithSep = this.parseDefaultOffsetFields(text, ++idx, ':', lenWithSep);
            if (lenWithSep[0] == text.length() - idx) {
                offset = offsetWithSep * sign;
                idx += lenWithSep[0];
            } else {
                int[] lenAbut = new int[]{0};
                int offsetAbut = this.parseAbuttingOffsetFields(text, idx, lenAbut);
                if (lenWithSep[0] > lenAbut[0]) {
                    offset = offsetWithSep * sign;
                    idx += lenWithSep[0];
                } else {
                    offset = offsetAbut * sign;
                    idx += lenAbut[0];
                }
            }
            parsed = idx - start;
        }
        parsedLength[0] = parsed;
        return offset;
    }

    private int parseDefaultOffsetFields(String text, int start, char separator, int[] parsedLength) {
        int max = text.length();
        int idx = start;
        int[] len = new int[]{0};
        int hour = 0;
        int min = 0;
        int sec = 0;
        hour = this.parseOffsetDigits(text, idx, 1, 2, 0, 23, len);
        if (len[0] != 0 && (idx += len[0]) + 1 < max && text.charAt(idx) == separator) {
            min = this.parseOffsetDigits(text, idx + 1, 2, 2, 0, 59, len);
            if (len[0] != 0 && (idx += 1 + len[0]) + 1 < max && text.charAt(idx) == separator) {
                sec = this.parseOffsetDigits(text, idx + 1, 2, 2, 0, 59, len);
                if (len[0] != 0) {
                    idx += 1 + len[0];
                }
            }
        }
        if (idx == start) {
            parsedLength[0] = 0;
            return 0;
        }
        parsedLength[0] = idx - start;
        return hour * 3600000 + min * 60000 + sec * 1000;
    }

    private int parseAbuttingOffsetFields(String text, int start, int[] parsedLength) {
        int MAXDIGITS = 6;
        int[] digits = new int[6];
        int[] parsed = new int[6];
        int idx = start;
        int[] len = new int[]{0};
        int numDigits = 0;
        for (int i = 0; i < 6; ++i) {
            digits[i] = this.parseSingleDigit(text, idx, len);
            if (digits[i] < 0) break;
            parsed[i] = (idx += len[0]) - start;
            ++numDigits;
        }
        if (numDigits == 0) {
            parsedLength[0] = 0;
            return 0;
        }
        int offset = 0;
        while (numDigits > 0) {
            int hour = 0;
            int min = 0;
            int sec = 0;
            assert (numDigits > 0 && numDigits <= 6);
            switch (numDigits) {
                case 1: {
                    hour = digits[0];
                    break;
                }
                case 2: {
                    hour = digits[0] * 10 + digits[1];
                    break;
                }
                case 3: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    break;
                }
                case 4: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    break;
                }
                case 5: {
                    hour = digits[0];
                    min = digits[1] * 10 + digits[2];
                    sec = digits[3] * 10 + digits[4];
                    break;
                }
                case 6: {
                    hour = digits[0] * 10 + digits[1];
                    min = digits[2] * 10 + digits[3];
                    sec = digits[4] * 10 + digits[5];
                }
            }
            if (hour <= 23 && min <= 59 && sec <= 59) {
                offset = hour * 3600000 + min * 60000 + sec * 1000;
                parsedLength[0] = parsed[numDigits - 1];
                break;
            }
            --numDigits;
        }
        return offset;
    }

    private int parseOffsetDigits(String text, int start, int minDigits, int maxDigits, int minVal, int maxVal, int[] parsedLength) {
        int tmpVal;
        int digit;
        int idx;
        parsedLength[0] = 0;
        int decVal = 0;
        int numDigits = 0;
        int[] digitLen = new int[]{0};
        for (idx = start; idx < text.length() && numDigits < maxDigits && (digit = this.parseSingleDigit(text, idx, digitLen)) >= 0 && (tmpVal = decVal * 10 + digit) <= maxVal; ++numDigits, idx += digitLen[0]) {
            decVal = tmpVal;
        }
        if (numDigits < minDigits || decVal < minVal) {
            decVal = -1;
            numDigits = 0;
        } else {
            parsedLength[0] = idx - start;
        }
        return decVal;
    }

    private int parseSingleDigit(String text, int offset, int[] len) {
        int digit = -1;
        len[0] = 0;
        if (offset < text.length()) {
            int cp = Character.codePointAt(text, offset);
            for (int i = 0; i < this._gmtOffsetDigits.length; ++i) {
                if (cp != this._gmtOffsetDigits[i].codePointAt(0)) continue;
                digit = i;
                break;
            }
            if (digit < 0) {
                digit = UCharacter.digit(cp);
            }
            if (digit >= 0) {
                len[0] = Character.charCount(cp);
            }
        }
        return digit;
    }

    private static String[] toCodePoints(String str) {
        int len = str.codePointCount(0, str.length());
        String[] codePoints = new String[len];
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            int code = str.codePointAt(offset);
            int codeLen = Character.charCount(code);
            codePoints[i] = str.substring(offset, offset + codeLen);
            offset += codeLen;
        }
        return codePoints;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initGMTPattern(this._gmtPattern);
        this.initGMTOffsetPatterns(this._gmtOffsetPatterns);
    }

    @Override
    public boolean isFrozen() {
        return this._frozen;
    }

    @Override
    public TimeZoneFormat freeze() {
        this._frozen = true;
        return this;
    }

    @Override
    public TimeZoneFormat cloneAsThawed() {
        TimeZoneFormat copy = (TimeZoneFormat)super.clone();
        copy._frozen = false;
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeZoneFormatCache
    extends SoftCache<ULocale, TimeZoneFormat, ULocale> {
        private TimeZoneFormatCache() {
        }

        @Override
        protected TimeZoneFormat createInstance(ULocale key, ULocale data) {
            TimeZoneFormat fmt = new TimeZoneFormat(data);
            fmt.freeze();
            return fmt;
        }
    }

    private static class GMTOffsetField {
        final char _type;
        final int _width;

        GMTOffsetField(char type, int width) {
            this._type = type;
            this._width = width;
        }

        char getType() {
            return this._type;
        }

        int getWidth() {
            return this._width;
        }

        static boolean isValid(char type, int width) {
            switch (type) {
                case 'H': {
                    return width == 1 || width == 2;
                }
                case 'm': 
                case 's': {
                    return width == 2;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeType {
        UNKNOWN,
        STANDARD,
        DAYLIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GMTOffsetPatternType {
        POSITIVE_HM("+HH:mm", "Hm", true),
        POSITIVE_HMS("+HH:mm:ss", "Hms", true),
        NEGATIVE_HM("-HH:mm", "Hm", false),
        NEGATIVE_HMS("-HH:mm:ss", "Hms", false);

        private String _defaultPattern;
        private String _required;
        private boolean _isPositive;

        private GMTOffsetPatternType(String defaultPattern, String required, boolean isPositive) {
            this._defaultPattern = defaultPattern;
            this._required = required;
            this._isPositive = isPositive;
        }

        private String defaultPattern() {
            return this._defaultPattern;
        }

        private String required() {
            return this._required;
        }

        private boolean isPositive() {
            return this._isPositive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        GENERIC_LOCATION,
        GENERIC_LONG,
        GENERIC_SHORT,
        SPECIFIC_LONG,
        SPECIFIC_SHORT,
        RFC822,
        LOCALIZED_GMT,
        SPECIFIC_SHORT_COMMONLY_USED;

    }
}

