/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CAMCSKKeyStore {
    protected static final String CSK_HEAD = "-----BEGIN CSK V3.0-----\n";
    protected static final String CSK_TAIL = "-----END CSK V3.0-----\n";
    protected static final String CSK_HEAD_40 = "-----BEGIN CSK V4.0-----\n";
    protected static final String CSK_TAIL_40 = "-----END CSK V4.0-----\n";
    protected static final int PBE_SALT_LENGTH = 24;
    protected static final int PBE_ITERATION_COUNT = 100;
    private HashMap<String, SecretKey> keyMap = new HashMap();
    private HashMap<String, Date> creationDateMap = new HashMap();

    public void load(String camCSKKeyStoreFile) throws CAMCryptoException {
        Configuration config = Configuration.getInstance();
        String cskPassword = config.getCSKPassword();
        List<? extends Object> cskEntry = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(camCSKKeyStoreFile)));
            String line = null;
            int version = 0;
            while ((line = reader.readLine()) != null) {
                if (line.compareTo(CSK_HEAD.trim()) == 0) {
                    version = 3;
                    continue;
                }
                if (line.compareTo(CSK_HEAD_40.trim()) == 0) {
                    version = 4;
                    continue;
                }
                if (line.compareTo(CSK_TAIL.trim()) == 0 || line.compareTo(CSK_TAIL_40.trim()) == 0) continue;
                if (version == 4) {
                    cskEntry = KeyStoreReader.getCSKEntryVer40(cskPassword, line);
                } else if (version == 3) {
                    cskEntry = KeyStoreReader.getCSKEntryVer30(cskPassword, line);
                }
                SecretKey csk = (SecretKey)cskEntry.get(0);
                Date creationDate = (Date)cskEntry.get(1);
                this.addKeyEntry(csk, creationDate);
            }
        }
        catch (CAMCryptoException | IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{camCSKKeyStoreFile}));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized SecretKey getKey(String alias) {
        SecretKey csk = this.keyMap.get(alias);
        return csk;
    }

    public synchronized Date getCreationDate(String alias) {
        Date creationDate = this.creationDateMap.get(alias);
        return creationDate;
    }

    public synchronized List<String> getAllAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        Set<Map.Entry<String, SecretKey>> set = this.keyMap.entrySet();
        for (Map.Entry<String, SecretKey> entry : set) {
            aliases.add(entry.getKey());
        }
        return aliases;
    }

    protected static SecretKey getSecertKeyfromString(String pwd, String algorithm, String provider) throws CAMCryptoException {
        SecretKeySpec key = null;
        try {
            KeyGenerator kg = KeyGenerator.getInstance(algorithm, provider);
            SecretKey k = kg.generateKey();
            int keySize = k.getEncoded().length;
            String shaAlg = "SHA256";
            MessageDigest md = MessageDigest.getInstance(shaAlg, provider);
            byte[] mdBytes = md.digest(pwd.getBytes());
            byte[] keyBytes = new byte[keySize];
            if (keySize > mdBytes.length) {
                IPFTraceFunction.trace("KeyStoreWrite::getSecertKeyfromString - Key size mismatch.");
            } else {
                System.arraycopy(mdBytes, 0, keyBytes, 0, keySize);
            }
            key = new SecretKeySpec(keyBytes, algorithm);
        }
        catch (Exception e) {
            IPFTraceFunction.trace("KeyStoreWrite::getSecertKeyfromString - Could not create CSK");
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_could_not_create_csk"));
        }
        return key;
    }

    private synchronized void addKeyEntry(SecretKey csk, Date creationDate) throws CAMCryptoException {
        byte[] cskDigest = CAMCryptoUtilities.digestCSK(csk);
        String alias = new String(CryptoWrapper.encodeBase64(cskDigest));
        if (this.keyMap.get(alias) == null) {
            this.keyMap.put(alias, csk);
            this.creationDateMap.put(alias, creationDate);
        }
    }
}

