/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.IJVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DigestAlgorithmManager {
    final HashMap mapping = new HashMap();

    public DigestAlgorithmManager(IJVMEnvironment jvmEnv) throws CAMCryptoException {
        this.mapping.put("SHA-224", "SHA-224");
        this.mapping.put("SHA-256", "SHA-256");
        this.mapping.put("SHA-384", "SHA-384");
        this.mapping.put("SHA-512", "SHA-512");
    }

    public DigestAlgorithmManager() throws CAMCryptoException {
        this(JVMEnvironment.getInstance());
    }

    public Vector getSupportedDigestAlgorithms(String jceProvider) throws CAMCryptoException {
        Provider p = Security.getProvider(jceProvider);
        Vector<String> digestAlgorithms = new Vector<String>();
        String keyEntry = null;
        int indx = 0;
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            MessageDigest md2;
            String alg;
            String key;
            keyEntry = (String)e.nextElement();
            if (keyEntry.startsWith("MessageDigest")) {
                key = keyEntry.substring("MessageDigest".length() + 1);
                alg = (String)this.mapping.get(key);
                if (alg == null) continue;
                try {
                    md2 = MessageDigest.getInstance(alg);
                    if (digestAlgorithms.contains(alg)) continue;
                    digestAlgorithms.add(alg);
                }
                catch (NoSuchAlgorithmException md2) {}
                continue;
            }
            indx = keyEntry.lastIndexOf("MessageDigest");
            if (indx <= 0 || (alg = (String)this.mapping.get(key = keyEntry.substring(indx + "MessageDigest".length() + 1))) == null) continue;
            try {
                md2 = MessageDigest.getInstance(alg);
                if (digestAlgorithms.contains(alg)) continue;
                digestAlgorithms.add(alg);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return digestAlgorithms;
    }

    public Element getSupportedDigestAlgorithmDOM(String jceProvider) throws CAMCryptoException {
        if (jceProvider == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_parameter"));
        }
        Vector vDigestAlgorithms = this.getSupportedDigestAlgorithms(jceProvider);
        Iterator i = vDigestAlgorithms.iterator();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        int order = 0;
        while (i.hasNext()) {
            String value = (String)i.next();
            root.addElement("enum").addAttribute("value", value).addAttribute("label", value).addAttribute("order", Integer.toString(order)).addAttribute("useLabel", new String("false"));
            ++order;
        }
        return document.getRootElement();
    }

    public Element getSupportedDigestAlgorithmDOM() throws CAMCryptoException {
        Iterator i = this.getSupportedDigestAlgorithms().iterator();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        int order = 0;
        while (i.hasNext()) {
            String value = (String)i.next();
            root.addElement("enum").addAttribute("value", value).addAttribute("label", value).addAttribute("order", Integer.toString(order)).addAttribute("useLabel", new String("false"));
            ++order;
        }
        return document.getRootElement();
    }

    public Vector getSupportedDigestAlgorithms() throws CAMCryptoException {
        Provider[] providers = Security.getProviders();
        HashSet digestAlgorithms = new HashSet();
        for (int i = 0; i < providers.length; ++i) {
            Provider jceProvider = providers[i];
            String providerName = jceProvider.getName();
            digestAlgorithms.addAll(this.getSupportedDigestAlgorithms(providerName));
        }
        return new Vector(digestAlgorithms);
    }
}

