/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SymmetricAlgorithmManager {
    private static Map mapping = new HashMap();
    private static List pdfAlgorithms;

    public static String getDispalyMessage(String theAlgorithm, String locale) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = SymmetricAlgorithmManager.lookupAlgorithm(theAlgorithm);
        return MessageSet.getMessage(algorithm.displayMessageId, locale);
    }

    public static int getEffectiveKeySize(String theAlgorithm) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = SymmetricAlgorithmManager.lookupAlgorithm(theAlgorithm);
        return algorithm.keySize;
    }

    public static String getId(String theAlgorithm) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = SymmetricAlgorithmManager.lookupAlgorithm(theAlgorithm);
        return algorithm.id;
    }

    public static String getLongName(String theAlgorithm) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = SymmetricAlgorithmManager.lookupAlgorithm(theAlgorithm);
        return algorithm.longName;
    }

    public static String getShortName(String theAlgorithm) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = SymmetricAlgorithmManager.lookupAlgorithm(theAlgorithm);
        return algorithm.shortName;
    }

    private static SymmeticKeyAlgorithm lookupAlgorithm(String theAlgorithm) throws CAMCryptoException {
        SymmeticKeyAlgorithm algorithm = (SymmeticKeyAlgorithm)mapping.get(theAlgorithm);
        if (algorithm == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_provider_unsupported_alg"));
        }
        return algorithm;
    }

    private void addEnumElement(Element root, String value, String locale) throws CAMCryptoException {
        String msgLabel = SymmetricAlgorithmManager.getDispalyMessage(value, locale);
        int start = msgLabel.indexOf(32);
        String label = msgLabel.substring(++start);
        root.addElement("enum").addAttribute("value", value).addAttribute("label", label).addAttribute("description", null).addAttribute("help", null).addAttribute("useLabel", new String("false"));
    }

    private Element getAlgorithmsEnumElement(Vector vSymmecticAlgs, String locale) throws CAMCryptoException {
        Iterator i = vSymmecticAlgs.iterator();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("values");
        while (i.hasNext()) {
            String value = (String)i.next();
            this.addEnumElement(root, value, locale);
        }
        Element e = document.getRootElement();
        return e;
    }

    public Vector getSupportedPDFAlgs(String sParameterType) throws CAMCryptoException {
        Vector<String> v = new Vector<String>();
        for (String algorithmKey : pdfAlgorithms) {
            if (!this.isSupported(algorithmKey, sParameterType)) continue;
            v.add(algorithmKey);
        }
        return v;
    }

    public Element getSupportedPDFAlgsDOM(String sParameterType, String locale) throws CAMCryptoException {
        Vector vPdfAlgs = this.getSupportedPDFAlgs(sParameterType);
        return this.getAlgorithmsEnumElement(vPdfAlgs, locale);
    }

    public Vector getSupportedSymmetricAlgs(String sParameterType) throws CAMCryptoException {
        Vector<String> v = new Vector<String>();
        for (String algorithmKey : mapping.keySet()) {
            if (!this.isSupported(algorithmKey, sParameterType)) continue;
            v.add(algorithmKey);
        }
        return v;
    }

    public Element getSupportedSymmetricAlgsDOM(String sParameterType, String locale) throws CAMCryptoException {
        Vector vSymmecticAlgs = this.getSupportedSymmetricAlgs(sParameterType);
        return this.getAlgorithmsEnumElement(vSymmecticAlgs, locale);
    }

    private boolean isSupported(String algorithm, String provider) throws CAMCryptoException {
        SymmeticKeyAlgorithm alg = SymmetricAlgorithmManager.lookupAlgorithm(algorithm);
        try {
            boolean jniSupported = JNISystemProperties.checkAlgorithm((String)algorithm, null);
            String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(alg.longName);
            boolean javaSupported = alg.keySize <= maxAllowedKeyLength && null != Cipher.getInstance(alg.longName, jceProvider);
            return jniSupported && javaSupported;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return false;
    }

    static {
        mapping.put("AES", new SymmeticKeyAlgorithm(128, "2.16.840.1.101.3.4.1.2", "AES", "AES/CBC/PKCS5Padding", "CAM_CRP_ConfidentialityAlgorithm_AES_128"));
        mapping.put("AES256", new SymmeticKeyAlgorithm(256, "2.16.840.1.101.3.4.1.42", "AES", "AES/CBC/PKCS5Padding", "CAM_CRP_ConfidentialityAlgorithm_AES_256"));
        mapping.put("3DES", new SymmeticKeyAlgorithm(168, "1.2.840.113549.3.7", "DESede", "DESede/CBC/PKCS5Padding", "CAM_CRP_ConfidentialityAlgorithm_3DES"));
        mapping = Collections.unmodifiableMap(mapping);
        pdfAlgorithms = new ArrayList();
        pdfAlgorithms.add("AES");
        pdfAlgorithms.add("AES256");
        pdfAlgorithms = Collections.unmodifiableList(pdfAlgorithms);
    }

    private static final class SymmeticKeyAlgorithm {
        private final int keySize;
        private final String id;
        private final String shortName;
        private final String longName;
        private final String displayMessageId;

        private SymmeticKeyAlgorithm(int theKeySize, String theId, String theShortName, String theLongName, String theDisplayMessageId) {
            this.keySize = theKeySize;
            this.id = theId;
            this.shortName = theShortName;
            this.longName = theLongName;
            this.displayMessageId = theDisplayMessageId;
        }
    }
}

