/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.xml;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.Token;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import javax.crypto.Mac;

class GenericTrustedSessionToken2
extends Token {
    private static final int CURRENT_VERSION = 2;
    protected static final String CLASS_ID = "GenericTrustedSession";
    private String algorithm;
    private byte[] cskDigest;
    private byte[] hmacDigest;
    private final Mac mac;
    private final byte[] c14nXml;

    GenericTrustedSessionToken2() {
        this.c14nXml = null;
        this.mac = null;
    }

    GenericTrustedSessionToken2(GenericTrustedSession session, GenericTrustedSessionToken2 token, byte[] c14nXml) throws CAMCryptoException {
        this(session, token.getAlgorithm(), token.getCskDigest(), c14nXml);
    }

    GenericTrustedSessionToken2(GenericTrustedSession session, String theAlgorithm, byte[] theCskDigest, byte[] theC14nXml) throws CAMCryptoException {
        this.mac = CAMCryptoUtilities.getMacGivenCSKDigest(theCskDigest, Configuration.getInstance().getHMACAlgorithm(theAlgorithm));
        this.algorithm = theAlgorithm;
        this.cskDigest = theCskDigest;
        this.c14nXml = theC14nXml;
    }

    boolean verifyToken(GenericTrustedSessionToken2 token) {
        return Arrays.equals(this.getHmacDigest(), token.getHmacDigest());
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        this.writeVersion(out, this.getCurrentVersion());
        this.writeAlgorithm(out, this.getAlgorithm());
        this.writeCSKDigest(out, this.getCskDigest());
        this.writeHmacDigest(out, this.getHmacDigest());
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        int version = this.readVersion(in);
        if (version != this.getCurrentVersion()) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_message_version"));
        }
        this.algorithm = this.readAlgorithm(in);
        this.cskDigest = this.readCSKDigest(in);
        this.hmacDigest = this.readHMacDigest(in);
    }

    protected int getCurrentVersion() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] generateHmacDigest() {
        if (this.getMac() == null || this.getC14nXml() == null) {
            throw new IllegalStateException();
        }
        Mac mac = this.getMac();
        synchronized (mac) {
            this.getMac().reset();
            this.getMac().update((byte)2);
            this.getMac().update(CLASS_ID.getBytes());
            this.getMac().update(this.getC14nXml());
            return this.getMac().doFinal();
        }
    }

    private byte[] getHmacDigest() {
        if (this.hmacDigest == null) {
            this.hmacDigest = this.generateHmacDigest();
        }
        return this.hmacDigest;
    }

    protected String getAlgorithm() {
        return this.algorithm;
    }

    protected byte[] getCskDigest() {
        return this.cskDigest;
    }

    protected Mac getMac() {
        return this.mac;
    }

    protected byte[] getC14nXml() {
        return this.c14nXml;
    }
}

