/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.diagnostics;

import com.cognos.ccl4j.exceptions.CCLIllegalArgumentException;
import com.cognos.ccl4j.exceptions.CCLIllegalStateException;
import com.cognos.ccl4j.exceptions.CCLIndexOutOfBoundsException;
import com.cognos.ccl4j.exceptions.CCLNoSuchElementException;
import com.cognos.ccl4j.exceptions.CCLNullArgumentException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.exceptions.CCLUnsupportedOperationException;
import com.cognos.ccl4j.util.CCLStringUtils;

public final class CCLCheck {
    public static final String DEBUG_PROPERTY = "com.cognos.ccl4j.diagnostics.CCLCheck.debug";
    public static boolean debug = Boolean.getBoolean("com.cognos.ccl4j.diagnostics.CCLCheck.debug");

    private CCLCheck() {
    }

    private static void printAndThrow(CCLRuntimeException except) {
        if (debug) {
            System.err.println("Printing for informational purposes; exception may actually be handled.");
            System.err.println(except.getMessage());
            except.printStackTrace();
        }
        throw except;
    }

    public static boolean isBadDouble(double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }

    public static boolean isBadString(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isInRange(double value, double lowInclusive, double highInclusive) {
        return value >= lowInclusive && value <= highInclusive;
    }

    public static boolean isInRange(long value, long lowInclusive, long highInclusive) {
        return value >= lowInclusive && value <= highInclusive;
    }

    public static boolean isNotNull(Object arg) {
        return arg != null;
    }

    public static boolean isOutOfRange(long value, long lowInclusive, long highInclusive) {
        return value < lowInclusive || value > highInclusive;
    }

    public static boolean isOutOfRange(double value, double lowInclusive, double highInclusive) {
        return value < lowInclusive || value > highInclusive;
    }

    public static boolean isValidDouble(double value) {
        return false == (Double.isNaN(value) || Double.isInfinite(value));
    }

    public static boolean isValidIndex(long index, long maxExclusive) {
        return CCLCheck.isInRange(index, 0L, maxExclusive - 1L);
    }

    public static boolean isValidIndex(long index, long minInclusive, long maxExclusive) {
        return CCLCheck.isInRange(index, minInclusive, maxExclusive - 1L);
    }

    public static boolean isBadIndex(long index, long maxExclusive) {
        return CCLCheck.isBadIndex(index, 0L, maxExclusive);
    }

    public static boolean isBadIndex(long index, long lowInclusive, long maxExclusive) {
        return CCLCheck.isOutOfRange(index, lowInclusive, maxExclusive - 1L);
    }

    public static boolean isValidString(String value) {
        return value != null && value.length() > 0;
    }

    public static void throwCCLRuntimeException(CCLRuntimeException rx) {
        CCLCheck.printAndThrow(rx);
    }

    public static void nonNull(Object value1) {
        if (value1 == null) {
            CCLCheck.throwArgumentNull();
        }
    }

    public static void nonNull(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2});
        }
    }

    public static void nonNull(Object value1, Object value2, Object value3) {
        if (value1 == null || value2 == null || value3 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2, value3});
        }
    }

    public static void nonNull(Object value1, Object value2, Object value3, Object value4) {
        if (value1 == null || value2 == null || value3 == null || value4 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2, value3, value4});
        }
    }

    public static void nonNull(Object value1, Object value2, Object value3, Object value4, Object value5) {
        if (value1 == null || value2 == null || value3 == null || value4 == null || value5 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2, value3, value4, value5});
        }
    }

    public static void nonNull(Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        if (value1 == null || value2 == null || value3 == null || value4 == null || value5 == null || value6 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2, value3, value4, value5, value6});
        }
    }

    public static void nonNull(Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        if (value1 == null || value2 == null || value3 == null || value4 == null || value5 == null || value6 == null || value7 == null) {
            CCLCheck.throwArgumentNull(new Object[]{value1, value2, value3, value4, value5, value6, value7});
        }
    }

    private static String buildNullObjectMessage(Object[] v) {
        Object[] vMsgs = new Object[v.length];
        for (int i = 0; i < v.length; ++i) {
            if (v[i] != null) continue;
            vMsgs[i] = "value" + Integer.toString(i + 1);
        }
        return CCLStringUtils.join(vMsgs, true);
    }

    public static void throwArgumentNull() {
        String msg = "Argument value is null";
        CCLCheck.printAndThrow(new CCLNullArgumentException(msg));
    }

    public static void throwArgumentNull(Object[] vObjects) {
        String sMsg = "Argument value is null: " + CCLCheck.buildNullObjectMessage(vObjects);
        CCLCheck.printAndThrow(new CCLNullArgumentException(sMsg));
    }

    public static void throwArgumentNull(String sMsg) {
        CCLCheck.printAndThrow(new CCLNullArgumentException(sMsg));
    }

    public static void throwIllegalArgumentExceptionMessage(String msg) {
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void throwIllegalArgumentException() {
        String msg = "Argument is not a legal value";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void throwIllegalArgumentException(Object arg) {
        String sArg = CCLCheck.getTrimmedObjectString(arg);
        String msg = "Argument value '" + sArg + "' is not legal";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void throwIllegalArgumentExceptionType() {
        String msg = "Argument is not the right type";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void nonNegative(long arg) {
        if (arg >= 0L) {
            return;
        }
        String msg = "Argument value " + arg + " is not >= 0";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void nonNegative(double arg) {
        if (arg >= 0.0) {
            return;
        }
        String msg = "Argument value " + arg + " is not >= 0";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void inRange(long value, long minInclusive, long maxInclusive) {
        if (CCLCheck.isInRange(value, minInclusive, maxInclusive)) {
            return;
        }
        String msg = "Argument value " + value + " is outside range '" + minInclusive + " <= " + value + " >= " + maxInclusive + "'";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void inRange(double value, double minInclusive, double maxInclusive) {
        if (CCLCheck.isInRange(value, minInclusive, maxInclusive)) {
            return;
        }
        String msg = "Argument value " + value + " is outside range '" + minInclusive + " <= " + value + " >= " + maxInclusive + "'";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void indexInBounds(int index, int maxExclusive) {
        if (CCLCheck.isValidIndex(index, maxExclusive)) {
            return;
        }
        CCLCheck.indexInBounds(index, 0, maxExclusive);
    }

    public static void indexInBounds(int index, int minInclusive, int maxExclusive) {
        if (CCLCheck.isValidIndex(index, minInclusive, maxExclusive)) {
            return;
        }
        String msg = "Index value " + index + " is outside range (" + minInclusive + ", " + maxExclusive + ")";
        CCLCheck.printAndThrow(new CCLIndexOutOfBoundsException(msg));
    }

    public static void throwNoSuchElement() {
        String msg = "There is no such element";
        CCLCheck.printAndThrow(new CCLNoSuchElementException(msg));
    }

    public static void throwNoSuchElement(int value) {
        String msg = "No such element number " + value;
        CCLCheck.printAndThrow(new CCLNoSuchElementException(msg));
    }

    public static void throwMustEqual(Object arg, Object other) {
        String sArg = CCLCheck.getTrimmedObjectString(arg);
        String sOther = CCLCheck.getTrimmedObjectString(other);
        String msg = "Object argument '" + sArg + "' must equal '" + sOther + "'";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void throwMustNotEqual(Object arg, Object other) {
        String sArg = CCLCheck.getTrimmedObjectString(arg);
        String sOther = CCLCheck.getTrimmedObjectString(other);
        String msg = "Object argument '" + sArg + "' must not equal '" + sOther + "'";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void validDouble(double value) {
        if (CCLCheck.isValidDouble(value)) {
            return;
        }
        String msg = "";
        msg = Double.isNaN(value) ? "Argument value of type double is NaN (not a number)" : "Argument value of type double is infinite";
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void validString(String string) {
        if (CCLCheck.isValidString(string)) {
            return;
        }
        String msg = "String argument value is zero-length string";
        if (string == null) {
            msg = "String argument is null";
        }
        CCLCheck.printAndThrow(new CCLIllegalArgumentException(msg));
    }

    public static void throwUnsupported() {
        String msg = "Operation is not supported";
        CCLCheck.printAndThrow(new CCLUnsupportedOperationException(msg));
    }

    public static void throwUnsupported(String sOperation) {
        String msg = "Operation is not supported";
        if (CCLCheck.isValidString(sOperation)) {
            msg = "Operation '" + msg + "' is not supported";
        }
        CCLCheck.printAndThrow(new CCLUnsupportedOperationException(msg));
    }

    public static void throwIllegalState(Object arg) {
        String sArg = CCLCheck.getTrimmedObjectString(arg);
        String msg = "Object '" + sArg + "' is in an illegal state.";
        CCLCheck.printAndThrow(new CCLIllegalStateException(msg));
    }

    public static void throwIllegalState(Object arg, String msg) {
        String sArg = CCLCheck.getTrimmedObjectString(arg);
        String combined = "Object '" + sArg + "' is in an illegal state; Message is '" + msg + "'";
        CCLCheck.printAndThrow(new CCLIllegalStateException(combined));
    }

    private static String getTrimmedObjectString(Object arg) {
        String sArg = "[null]";
        if (arg != null) {
            sArg = CCLStringUtils.trim(arg.toString(), 100);
        }
        return sArg;
    }
}

