/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.resource;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.logging.CCLNullDebugLogger;
import com.cognos.ccl4j.logging.CCLNullServiceAuditLogger;
import com.cognos.ccl4j.logging.ICCLDebugLogging;
import com.cognos.ccl4j.logging.ICCLLoggable;
import com.cognos.ccl4j.logging.ICCLServiceAuditLogging;
import com.cognos.ccl4j.resource.CCLMessageFile;
import com.cognos.ccl4j.resource.CCLResource;
import com.cognos.ccl4j.resource.ICCLResourceLoader;
import com.cognos.ccl4j.resource.ICCLResourceManager;
import com.cognos.ccl4j.util.CCLExceptionHelper;
import com.cognos.ccl4j.util.CCLFileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CCLResourceManager
implements ICCLResourceManager {
    HashMap _mResources;
    ICCLServiceAuditLogging _logService = null;
    ICCLDebugLogging _logDebug = null;
    private boolean _bDoDynamicResourceRefresh_dontUseDirectly = false;
    private boolean _bForceNoDynamicResourceRefresh = false;
    private String _sDeveloperMsgsdkDirpath = null;
    private String _sInstallMsgsdkDirpath = null;
    private ArrayList _vResourceLoaders = new ArrayList();
    private boolean _bLoadFromMsgsdk = false;

    @Override
    public String getDeveloperMsgsdkDirpath() {
        return this._sDeveloperMsgsdkDirpath;
    }

    @Override
    public String getInstallMsgsdkDirpath() {
        return this._sInstallMsgsdkDirpath;
    }

    public void setLoadFromMsgsdk(boolean b, String sInstallMsgsdkDirpath) {
        this._bLoadFromMsgsdk = b;
        this._sInstallMsgsdkDirpath = sInstallMsgsdkDirpath;
    }

    @Override
    public boolean shouldLoadFromMsgsdk() {
        return this._bLoadFromMsgsdk;
    }

    public CCLResourceManager(String[] vResourceFilenames, String sInstallMsgsdkDirpath, ICCLServiceAuditLogging logService, ICCLDebugLogging logDebug) {
        this._logService = logService;
        if (this._logService == null) {
            this._logService = CCLNullServiceAuditLogger.getNullLogger();
        }
        this._logDebug = logDebug;
        if (this._logDebug == null) {
            this._logDebug = CCLNullDebugLogger.getNullLogger();
        }
        if (vResourceFilenames != null) {
            for (int i = 0; i < vResourceFilenames.length; ++i) {
                String sFilename = vResourceFilenames[i];
                CCLMessageFile rfi = new CCLMessageFile(sFilename);
                this.addResourceLoader(rfi);
            }
        }
        if (sInstallMsgsdkDirpath != null) {
            this._sInstallMsgsdkDirpath = CCLFileUtils.getNicePath(sInstallMsgsdkDirpath);
        }
        this._mResources = new HashMap(57);
    }

    public void setDynamicResourceReloading(boolean bDoDynamicResourceRefresh, String sResourceSourceDir) {
        this._bDoDynamicResourceRefresh_dontUseDirectly = bDoDynamicResourceRefresh;
        this._sDeveloperMsgsdkDirpath = sResourceSourceDir;
        if (this._sDeveloperMsgsdkDirpath != null) {
            this._sDeveloperMsgsdkDirpath = CCLFileUtils.getNicePath(this._sDeveloperMsgsdkDirpath);
        }
    }

    @Override
    public boolean getDynamicResourceReloading() {
        boolean bRet = false;
        if (!this._bForceNoDynamicResourceRefresh) {
            bRet = this._bDoDynamicResourceRefresh_dontUseDirectly;
        }
        return bRet;
    }

    public void setForceNoDynamicResourceReloads(boolean b) {
        this._bForceNoDynamicResourceRefresh = b;
    }

    public static Locale getLocale(String sLanguageCode) {
        Locale loc = null;
        String sLanguage = null;
        String sCountry = "";
        int nIdx_underscore = sLanguageCode.indexOf(95);
        if (nIdx_underscore == -1) {
            nIdx_underscore = sLanguageCode.indexOf(45);
        }
        if (nIdx_underscore > -1) {
            sLanguage = sLanguageCode.substring(0, nIdx_underscore);
            sCountry = sLanguageCode.substring(nIdx_underscore + 1);
        } else {
            sLanguage = sLanguageCode.toLowerCase();
            if (sLanguage.equals("de")) {
                sCountry = "DE";
            } else if (sLanguage.equals("en")) {
                sCountry = "US";
            } else if (sLanguage.equals("es")) {
                sCountry = "ES";
            } else if (sLanguage.equals("fi")) {
                sCountry = "FI";
            } else if (sLanguage.equals("fr")) {
                sCountry = "FR";
            } else if (sLanguage.equals("it")) {
                sCountry = "IT";
            } else if (sLanguage.equals("ja")) {
                sCountry = "JP";
            } else if (sLanguage.equals("nl")) {
                sCountry = "NL";
            } else if (sLanguage.equals("pt")) {
                sCountry = "PT";
            } else if (sLanguage.equals("sv")) {
                sCountry = "SE";
            }
        }
        if (sLanguage != null) {
            sCountry = sCountry.toUpperCase();
            loc = new Locale(sLanguage, sCountry);
        }
        return loc;
    }

    public static List getAvailableLocaleStrings(String sInstallMsgsdkDirpath, String sResourceFilenamePrefix_param) {
        ArrayList<String> vRet = new ArrayList<String>();
        final String sResourceFilenamePrefix = sResourceFilenamePrefix_param;
        File fMsgsdkDir = new File(sInstallMsgsdkDirpath);
        if (fMsgsdkDir.exists()) {
            FilenameFilter fnf = new FilenameFilter(){

                @Override
                public boolean accept(File f, String s) {
                    int nPrefixLen;
                    int nLen;
                    boolean bRet = false;
                    if (s.startsWith(sResourceFilenamePrefix) && s.endsWith(".xml") && ((nLen = s.length()) == (nPrefixLen = sResourceFilenamePrefix.length()) + 7 || nLen == nPrefixLen + 10)) {
                        bRet = true;
                    }
                    return bRet;
                }
            };
            int nPrefixLen = sResourceFilenamePrefix.length();
            String[] vFilenames = fMsgsdkDir.list(fnf);
            for (int i = 0; i < vFilenames.length; ++i) {
                String sFilename = vFilenames[i];
                String sLocaleString = sFilename.substring(nPrefixLen + 1, sFilename.length() - 4);
                vRet.add(sLocaleString);
            }
        }
        return vRet;
    }

    public static String bestLocaleMatch(String sId, Locale loc, List vItems) {
        String sRet = null;
        sRet = CCLResourceManager.bestLocaleMatch_singleLocale(sId, loc, vItems, false);
        if (sRet == null) {
            sRet = CCLResourceManager.bestLocaleMatch_singleLocale(sId, Locale.getDefault(), vItems, false);
        }
        if (sRet == null) {
            sRet = CCLResourceManager.bestLocaleMatch_singleLocale(sId, Locale.ENGLISH, vItems, true);
        }
        return sRet;
    }

    public static String bestLocaleMatch_singleLocale(String sId, Locale loc, List vItems, boolean bReturnDefault) {
        CCLCheck.validString(sId);
        CCLCheck.nonNull(vItems);
        String sRet = null;
        String sNoLangMatch = null;
        String sNoCountryMatch = null;
        String sFirstCountryMatch = null;
        String sLangToMatch = null;
        String sCountryToMatch = null;
        if (loc != null) {
            sLangToMatch = loc.getLanguage();
            sCountryToMatch = loc.getCountry();
        }
        for (String sItem : vItems) {
            String[] vResource = CCLResourceManager.parseLocalizedResourceName(sItem);
            if (!sId.equals(vResource[0])) continue;
            boolean bMatch = true;
            if (vResource[1] != null) {
                String[] vLocale = CCLResourceManager.parseLocaleString(vResource[1]);
                if (sLangToMatch == null || vLocale[0] == null || !vLocale[0].equals(sLangToMatch)) {
                    bMatch = false;
                    if (sNoLangMatch != null) continue;
                    sNoLangMatch = sItem;
                    continue;
                }
                if (vLocale[1] != null) {
                    if (sCountryToMatch != null && vLocale[1] != null && vLocale[1].equalsIgnoreCase(sCountryToMatch)) {
                        sRet = sItem;
                        break;
                    }
                    bMatch = false;
                    if (sNoCountryMatch == null && vLocale[1] == null) {
                        sNoCountryMatch = sItem;
                    }
                    if (sFirstCountryMatch != null || vLocale[1] == null) continue;
                    sFirstCountryMatch = sItem;
                    continue;
                }
                if (!bMatch || sRet != null && (sRet == null || sItem.length() <= sRet.length())) continue;
                sRet = sItem;
                continue;
            }
            if (sNoLangMatch != null) continue;
            sNoLangMatch = sItem;
        }
        if (sRet == null && sNoCountryMatch != null) {
            sRet = sNoCountryMatch;
        }
        if (sRet == null && sFirstCountryMatch != null) {
            sRet = sFirstCountryMatch;
        }
        if (sRet == null && sNoLangMatch != null && bReturnDefault) {
            sRet = sNoLangMatch;
        }
        return sRet;
    }

    public static String[] parseLocalizedResourceName(String sFullName) {
        int nDashIdx;
        char ch;
        String[] vRet = new String[2];
        CCLCheck.validString(sFullName);
        int n = sFullName.lastIndexOf(46);
        if (n > -1) {
            sFullName = sFullName.substring(0, n);
        }
        n = -1;
        if (sFullName.length() >= 4 && ((ch = sFullName.charAt(nDashIdx = sFullName.length() - 3)) == '_' || ch == '-')) {
            n = nDashIdx;
            if (sFullName.length() >= 7 && ((ch = sFullName.charAt(nDashIdx = sFullName.length() - 6)) == '_' || ch == '-')) {
                n = nDashIdx;
            }
        }
        String sName = sFullName;
        String sLocale = null;
        if (n > -1) {
            sName = sFullName.substring(0, n);
            sLocale = sFullName.substring(n + 1);
        }
        vRet[0] = sName;
        vRet[1] = sLocale;
        return vRet;
    }

    public static String[] parseLocaleString(String sLocale) {
        CCLCheck.validString(sLocale);
        if (sLocale.length() != 2 && sLocale.length() != 5) {
            throw new CCLRuntimeException("attempting to parse invalid locale string '" + sLocale + "'");
        }
        String[] vRet = new String[2];
        String sLang = sLocale;
        String sCountry = null;
        if (sLocale.length() == 5 && (sLocale.charAt(2) == '-' || sLocale.charAt(2) == '_')) {
            sLang = sLocale.substring(0, 2);
            sCountry = sLocale.substring(3);
        }
        vRet[0] = sLang;
        vRet[1] = sCountry;
        return vRet;
    }

    private void propagateLoggers(Object obj) {
        if (obj instanceof ICCLLoggable) {
            ICCLLoggable loggable = (ICCLLoggable)obj;
            loggable.setLoggers(this._logService, this._logDebug);
        }
    }

    public final void addResourceLoader(ICCLResourceLoader cll) {
        try {
            cll.prepare(this);
            this.propagateLoggers(cll);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "preparing resource loader: '" + cll.toString() + "'");
        }
        this._vResourceLoaders.add(cll);
    }

    public Iterator loaderIterator() {
        return this._vResourceLoaders.iterator();
    }

    public CCLResource getResourceForLanguage_OnlyIfLoaded(String sLanguage) {
        CCLResource res = (CCLResource)this._mResources.get(sLanguage);
        return res;
    }

    public CCLResource getResourceForLocale(Locale locale) {
        CCLResource res = null;
        try {
            String sLang = locale.getLanguage();
            String sCountry = locale.getCountry();
            StringBuffer sb = new StringBuffer(20);
            sb.append(sLang);
            if (sCountry != null && sCountry.length() > 0) {
                sb.append('_');
                sb.append(sCountry);
            }
            String sLocale = sb.toString();
            res = this.getResourceForLanguage(sLocale);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "getting resource for locale '" + locale.toString() + "'");
        }
        return res;
    }

    public static String normalizeLanguage(String sLang) {
        String sLang_out = sLang.toLowerCase();
        if (sLang_out.indexOf(95) > -1 || sLang_out.indexOf(45) > -1) {
            sLang_out = sLang_out.substring(0, 2) + "_" + sLang_out.substring(3).toUpperCase();
        }
        return sLang_out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCLResource getResourceForLanguage(String sLanguage_in) {
        CCLResource res;
        block14: {
            res = null;
            String sLanguage = CCLResourceManager.normalizeLanguage(sLanguage_in);
            try {
                Locale locale = CCLResourceManager.getLocale(sLanguage);
                CCLResource resPrevious = res = (CCLResource)this._mResources.get(sLanguage);
                if (res != null && this.getDynamicResourceReloading()) {
                    for (ICCLResourceLoader ldr : this._vResourceLoaders) {
                        CCLResource.LoadHandle hLoad;
                        if (!ldr.needsReload(res, hLoad = this.getLoadHandleForLoader(resPrevious, ldr))) continue;
                        if (this._logDebug.debug3_enabled()) {
                            String sHandleString = "";
                            if (hLoad != null) {
                                sHandleString = " based on handle " + hLoad.toString();
                            }
                            this._logDebug.debug3("Resource-loader needs reload: " + ldr.toString() + sHandleString);
                        }
                        res = null;
                        break;
                    }
                }
                if (res != null) break block14;
                CCLResourceManager cCLResourceManager = this;
                synchronized (cCLResourceManager) {
                    res = new CCLResource(sLanguage, locale, this);
                    this.propagateLoggers(res);
                    for (ICCLResourceLoader ldr : this._vResourceLoaders) {
                        CCLResource.LoadHandle hLoad = this.getLoadHandleForLoader(resPrevious, ldr);
                        if (this._logDebug.debug3_enabled()) {
                            String sHandleString = "";
                            if (hLoad != null) {
                                sHandleString = " based on handle " + hLoad.toString();
                            }
                            this._logDebug.debug3("Reloading resource-loader: " + ldr.toString() + sHandleString);
                        }
                        hLoad = ldr.loadIntoResource(res, hLoad);
                        if (this._logDebug.debug4_enabled() && hLoad != null) {
                            this._logDebug.debug4("New resource-loader handle: " + hLoad.toString());
                        }
                        res.setHandleForLoader(ldr, hLoad);
                    }
                    res.markStrings();
                    res.resolveVariables();
                    this._mResources.put(sLanguage, res);
                    if (this._logDebug.debug2_enabled()) {
                        this._logDebug.debug2("Replaced language '" + sLanguage + "' in resource manager.");
                    }
                }
            }
            catch (Exception ex) {
                CCLRuntimeException cclrex = new CCLRuntimeException(ex, "getting resource for language '" + sLanguage + "'");
                CCLExceptionHelper.printLocalizedStackTrace((Throwable)ex, (CCLResource)null);
                ex.printStackTrace();
                throw cclrex;
            }
        }
        return res;
    }

    private CCLResource.LoadHandle getLoadHandleForLoader(CCLResource res, ICCLResourceLoader ldr) {
        CCLResource.LoadHandle hRet = null;
        if (res != null) {
            hRet = res.getHandleForLoader(ldr);
        }
        return hRet;
    }
}

