/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.exceptions.ICCLExceptionHandling;
import com.cognos.ccl4j.message.CCLMsgInfo;
import com.cognos.ccl4j.resource.CCLResource;
import com.cognos.ccl4j.resource.CCLResourceManager;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CCLExceptionHelper {
    private CCLExceptionHelper() {
    }

    public static void prepareMessage(Throwable ex, CCLResource res) {
        if (ex != null && ex instanceof ICCLExceptionHandling) {
            ICCLExceptionHandling icclex = (ICCLExceptionHandling)((Object)ex);
            icclex.prepareMessage(res);
        }
    }

    public static Exception localizeException(Throwable th, CCLResource res) {
        Exception exRet = null;
        exRet = th instanceof Exception ? (Exception)th : new CCLException(th);
        CCLExceptionHelper.prepareMessage(exRet, res);
        return exRet;
    }

    public static String getLocalizedMessage(Throwable th, CCLResource res) {
        String sRet = null;
        if (th instanceof ICCLExceptionHandling) {
            ICCLExceptionHandling icclex = (ICCLExceptionHandling)((Object)th);
            sRet = icclex.getLocalizedMessage(res);
        } else {
            sRet = th.getLocalizedMessage();
        }
        return sRet;
    }

    public static String getPresentableMessage(Throwable th, CCLResource res) {
        String sRet = null;
        if (th != null && th instanceof ICCLExceptionHandling) {
            ICCLExceptionHandling ialpex = (ICCLExceptionHandling)((Object)th);
            CCLMsgInfo miEx = ialpex.getMsgInfo();
            CCLMsgInfo miClient = miEx.getClientAndPresentableMsgInfo();
            sRet = res.get(miClient);
        }
        return sRet;
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResource res) {
        CCLExceptionHelper._printLocalizedStackTrace(th, res, null);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr) {
        CCLExceptionHelper.printLocalizedStackTrace(th, resMgr, "en");
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, String sLanguage) {
        CCLExceptionHelper._printLocalizedStackTrace(th, resMgr, sLanguage, null);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResource res, PrintStream ps) {
        CCLExceptionHelper._printLocalizedStackTrace(th, res, ps);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, PrintStream ps) {
        CCLExceptionHelper.printLocalizedStackTrace(th, resMgr, "en", ps);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, String sLanguage, PrintStream ps) {
        CCLExceptionHelper._printLocalizedStackTrace(th, resMgr, sLanguage, ps);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResource res, PrintWriter pw) {
        CCLExceptionHelper._printLocalizedStackTrace(th, res, pw);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, PrintWriter pw) {
        CCLExceptionHelper.printLocalizedStackTrace(th, resMgr, "en", pw);
    }

    public static void printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, String sLanguage, PrintWriter pw) {
        CCLExceptionHelper._printLocalizedStackTrace(th, resMgr, sLanguage, pw);
    }

    private static void _printLocalizedStackTrace(Throwable th, CCLResourceManager resMgr, String sLanguage, Object print) {
        CCLResource res = null;
        if (resMgr != null) {
            res = resMgr.getResourceForLanguage(sLanguage);
        }
        CCLExceptionHelper._printLocalizedStackTrace(th, res, print);
    }

    private static void _printLocalizedStackTrace(Throwable th, CCLResource res, Object print) {
        if (print == null) {
            if (th instanceof ICCLExceptionHandling) {
                ICCLExceptionHandling alpex = (ICCLExceptionHandling)((Object)th);
                alpex.printStackTrace(res);
            } else {
                th.printStackTrace();
            }
        } else if (print instanceof PrintWriter) {
            PrintWriter pw = (PrintWriter)print;
            if (th instanceof ICCLExceptionHandling) {
                ICCLExceptionHandling alpex = (ICCLExceptionHandling)((Object)th);
                alpex.printStackTrace(pw, res);
            } else {
                th.printStackTrace(pw);
            }
        } else if (print instanceof PrintStream) {
            PrintStream ps = (PrintStream)print;
            if (th instanceof ICCLExceptionHandling) {
                ICCLExceptionHandling alpex = (ICCLExceptionHandling)((Object)th);
                alpex.printStackTrace(ps, res);
            } else {
                th.printStackTrace(ps);
            }
        } else {
            throw new CCLRuntimeException("Invalid printing object sent to CCLException.printLocalizeStackTrace: object='" + print.toString() + "'");
        }
    }

    public static CCLMsgInfo getMsgInfoFromThrowable(Throwable th) {
        CCLMsgInfo msgInfo = null;
        if (th != null && th instanceof ICCLExceptionHandling) {
            ICCLExceptionHandling ialpex = (ICCLExceptionHandling)((Object)th);
            msgInfo = ialpex.getMsgInfo();
        }
        return msgInfo;
    }
}

