/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.logging.LogAuditMessage;
import com.cognos.logging.LogExecutionContext;
import com.cognos.logging.LogNameValueCollection;

public class LogAuditAccessMessage
extends LogAuditAccessIndication {
    public final String LOG_START_TRACE_TAG = "<trace>";
    public final String LOG_STOP_TRACE_TAG = "</trace>";

    public LogAuditAccessMessage(String compName, int buildNum) {
        super(compName, buildNum);
    }

    public LogAuditAccessMessage() {
    }

    public LogAuditAccessMessage(LogExecutionContext c0) {
        super(c0.m_compID, c0.m_buildNo);
        this.setExecutionContext(c0);
    }

    public void setExecutionContext(LogExecutionContext c0) {
        this.setSessionID(c0.m_sessionID);
        this.setRequestID(c0.m_requestID);
        this.setStepID(c0.m_stepID);
        this.setSubRequestID(c0.m_subRequestID);
    }

    public void setStackTraceLogData(String logData) {
        if (null == logData) {
            logData = "";
        }
        this.m_logData = "<trace>" + logData + "</trace>";
    }

    public void setParametersLogData(LogNameValueCollection c) {
        this.m_logData = LogAuditMessage.buildParameters(c);
    }

    public void setErrorMessage(String[] strArray) {
        if (null == strArray || strArray.length == 0) {
            this.m_errorMessage = "";
            return;
        }
        StringBuffer errBuf = new StringBuffer("<messages>");
        for (int ii = 0; ii < strArray.length; ++ii) {
            errBuf.append("<message><messageString>");
            errBuf.append(strArray[ii]);
            errBuf.append("</message></messageString>");
        }
        errBuf.append("</messages>");
        this.m_errorMessage = errBuf.toString();
    }

    public void setTraceLogData(String logData) {
        if (null == logData) {
            logData = "";
        }
        this.m_logData = "<trace>" + logData + "</trace>";
        if (this.m_level == Integer.MAX_VALUE) {
            this.m_level = 10000;
        }
    }
}

