/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logging;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIPFControl;
import com.cognos.indications.LogTypedLoggerLegacy;
import com.cognos.logging.LogAuditAccessMessage;
import com.cognos.logging.LogAuditMessage;
import com.cognos.logging.LogConstants;
import com.cognos.logging.LogException;
import com.cognos.logging.LogExecutionContext;
import com.cognos.logging.LogNameValueCollection;
import com.cognos.logging.LogRuntimeException;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogAuditLogger
extends LogTypedLoggerLegacy
implements Observer,
LogConstants {
    protected boolean enabled_Service = true;
    protected boolean enabled_UserSession = false;
    protected boolean enabled_UserAction = false;
    protected boolean enabled_BusRequest = false;
    protected boolean enabled_Detail = false;

    protected LogAuditLogger(String name, Logger l4j2Logger, Class<?> clazz) {
        super(name, l4j2Logger, clazz);
    }

    private static LogAuditLogger getALogger(String logPrefix, String loggerName) throws LogException {
        try {
            LogTypedLoggerLegacy aLog = LogAuditLogger.getInstance((String)(logPrefix + loggerName), LogAuditIndication.class, LogAuditLogger::new);
            LogAuditLogger tLogger = (LogAuditLogger)aLog;
            LogIPFControl.addConfigObserver((Observer)tLogger);
            Level myLevel = tLogger.getLevel();
            tLogger.setEnabledProperties(myLevel);
            return tLogger;
        }
        catch (Exception e) {
            LogException ex = new LogException();
            ex.init(e, LogRuntimeException.getLogMessage(1));
            throw ex;
        }
    }

    public static LogAuditLogger getCogLogger(String loggerName) throws LogException {
        return LogAuditLogger.getALogger("Audit.", loggerName);
    }

    public static LogAuditLogger getCogUsageLogger(String loggerName) throws LogException {
        return LogAuditLogger.getALogger("Audit.RTUsage.", loggerName);
    }

    public static LogAuditLogger getCogAdminLogger(String loggerName) throws LogException {
        return LogAuditLogger.getALogger("Audit.Admin.", loggerName);
    }

    public static LogAuditLogger getCogOtherLogger(String loggerName) throws LogException {
        return LogAuditLogger.getALogger("Audit.Other.", loggerName);
    }

    public boolean isEnabled(int level) {
        return super.isEnabled(level);
    }

    public void log(LogAuditMessage p0) throws LogRuntimeException {
        if (p0.getLevel() < 20000) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        super.log((Object)p0);
    }

    public void log(LogAuditAccessMessage p0) throws LogRuntimeException {
        if (p0.getLevel() > 30000) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        super.log((Object)p0);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setEnabledProperties(this.getLevel());
    }

    private void setEnabledProperties(Level someLevel) {
        if (someLevel == Level.FATAL) {
            this.enabled_Service = true;
            this.enabled_UserSession = false;
            this.enabled_UserAction = false;
            this.enabled_BusRequest = false;
            this.enabled_Detail = false;
            return;
        }
        if (someLevel == Level.ERROR) {
            this.enabled_Service = true;
            this.enabled_UserSession = true;
            this.enabled_UserAction = false;
            this.enabled_BusRequest = false;
            this.enabled_Detail = false;
            return;
        }
        if (someLevel == Level.WARN) {
            this.enabled_Service = true;
            this.enabled_UserSession = true;
            this.enabled_UserAction = true;
            this.enabled_BusRequest = false;
            this.enabled_Detail = false;
            return;
        }
        if (someLevel == Level.INFO) {
            this.enabled_Service = true;
            this.enabled_UserSession = true;
            this.enabled_UserAction = true;
            this.enabled_BusRequest = true;
            this.enabled_Detail = false;
            return;
        }
        if (someLevel == Level.DEBUG) {
            this.enabled_Service = true;
            this.enabled_UserSession = true;
            this.enabled_UserAction = true;
            this.enabled_BusRequest = true;
            this.enabled_Detail = true;
            return;
        }
    }

    public void log(LogExecutionContext p0, int level, String status, String[] errMsg, String operation, String objType, String objCMPath, LogNameValueCollection c) throws LogRuntimeException {
        if (!super.isEnabled(level)) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        LogAuditAccessMessage am = new LogAuditAccessMessage(p0);
        am.setLogData(LogAuditMessage.buildParameters(c));
        am.setLevel(level);
        am.setOperation(operation);
        am.setObjectPath(objCMPath);
        am.setObjectType(objType);
        am.setErrorMessage(errMsg);
        am.setStatus(status);
        super.log((Object)am);
    }

    public void log(LogExecutionContext p0, int level, String status, String[] errMsg, String operation, String objType, String objCMPath, String logData) throws LogRuntimeException {
        if (!super.isEnabled(level)) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        LogAuditAccessMessage am = new LogAuditAccessMessage(p0);
        am.setTraceLogData(logData);
        am.setLevel(level);
        am.setOperation(operation);
        am.setObjectPath(objCMPath);
        am.setObjectType(objType);
        am.setErrorMessage(errMsg);
        am.setStatus(status);
        super.log((Object)am);
    }

    public void log(LogExecutionContext p0, String operation, String funcName, String funcRetType, LogNameValueCollection c) throws LogRuntimeException {
        if (!super.isEnabled(10000)) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        LogAuditMessage am = new LogAuditMessage(p0);
        am.setFunctionLogData(funcName, funcRetType, c);
        am.setLevel(10000);
        am.setOperation(operation);
        super.log((Object)am);
    }

    public void log(LogExecutionContext p0, int level, String operation, String logData) throws LogRuntimeException {
        if (!super.isEnabled(level)) {
            LogRuntimeException ex = new LogRuntimeException(2);
            throw ex;
        }
        LogAuditMessage am = new LogAuditMessage(p0);
        am.setLogData(logData);
        am.setLevel(level);
        am.setOperation(operation);
        super.log((Object)am);
    }
}

