/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logging;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LogRuntimeException
extends RuntimeException {
    private int m_errorCode = 0;
    private String m_message = null;
    private static ResourceBundle m_resources = ResourceBundle.getBundle("coglog");
    public static final int LOGIPF_GenericError = 0;
    public static final int LOGIPF_NoLogger = 1;
    public static final int LOGIPF_LevelRuntimeError = 2;
    public static final int LOGIPF_OperationRuntimeError = 3;
    public static final int LOGIPF_EmptyParamRuntimeError = 4;
    public static final int LOGIPF_IndexOutOfRange = 5;

    public LogRuntimeException() {
    }

    public LogRuntimeException(String s) {
        super(s);
        this.m_message = s;
    }

    public LogRuntimeException(int errorCode, Object[] params) {
        String key = LogRuntimeException.getErrorStringKey(errorCode);
        String value = null;
        if (null != m_resources) {
            value = this.generateMessage(m_resources.getString(key), params);
        }
        if (null == value) {
            value = key;
        }
        this.m_message = value;
        this.m_errorCode = errorCode;
    }

    public LogRuntimeException(int errorCode) {
        String key = LogRuntimeException.getErrorStringKey(errorCode);
        String value = null;
        if (null != m_resources) {
            value = m_resources.getString(key);
        }
        if (null == value) {
            value = key;
        }
        this.m_message = value;
        this.m_errorCode = errorCode;
    }

    public LogRuntimeException(int errorCode, Throwable ex) {
        String key = LogRuntimeException.getErrorStringKey(errorCode);
        String value = null;
        if (null != m_resources) {
            value = m_resources.getString(key);
        }
        if (null == value) {
            value = key;
        }
        this.m_message = value;
        this.m_errorCode = errorCode;
    }

    public static String getErrorStringKey(int errorCode) {
        String key = null;
        switch (errorCode) {
            case 1: {
                key = "COGLOG_01";
                break;
            }
            case 2: {
                key = "COGLOG_02";
                break;
            }
            case 3: {
                key = "COGLOG_03";
                break;
            }
            case 4: {
                key = "COGLOG_04";
                break;
            }
            case 5: {
                key = "COGLOG_05";
                break;
            }
            default: {
                key = "COGLOG_00";
            }
        }
        return key;
    }

    public String generateMessage(String sMsg, Object[] parms) {
        String sFormattedMsg = null;
        if (sMsg != null) {
            StringBuffer newMsgFormat = new StringBuffer(sMsg.length());
            int idx = 0;
            int startIdx = 0;
            while ((idx = sMsg.indexOf(39, startIdx)) != -1) {
                newMsgFormat.append(sMsg.substring(startIdx, idx + 1));
                newMsgFormat.append('\'');
                startIdx = idx + 1;
            }
            newMsgFormat.append(sMsg.substring(startIdx));
            MessageFormat oMsgFormatter = new MessageFormat("");
            oMsgFormatter.applyPattern(newMsgFormat.toString());
            sFormattedMsg = oMsgFormatter.format(parms);
        }
        return sFormattedMsg;
    }

    @Override
    public String getMessage() {
        if (null != this.m_message) {
            return this.m_message;
        }
        return super.getMessage();
    }

    public static String getLogMessage(int errorCode) {
        String key = LogRuntimeException.getErrorStringKey(errorCode);
        if (null == key) {
            return key;
        }
        String value = null;
        if (null != m_resources) {
            value = m_resources.getString(key);
        }
        return value;
    }

    @Override
    public String getLocalizedMessage() {
        if (null != this.m_message) {
            return this.m_message;
        }
        return super.getLocalizedMessage();
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }
}

