/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.api;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@Managed
public class CDNPathResolver {
    private Map<String, Pattern> patternMap = new HashMap<String, Pattern>();

    public String resolve(String value, PerspectiveContext context) {
        JsonObject cdnCtx;
        if (value != null && value.contains("CDN_COMPONENT") && (cdnCtx = context.getAdditionalContext("cdn")) != null) {
            String regex = cdnCtx.getString("regex");
            String replacement = cdnCtx.getString("replacement");
            if (regex != null && replacement != null) {
                return this.doReplace(value, regex, replacement);
            }
        }
        return value;
    }

    protected String doReplace(String s, String regex, String replacement) {
        Pattern p = this.patternMap.get(regex);
        if (p == null) {
            p = Pattern.compile(regex);
            this.patternMap.put(regex, p);
        }
        return p.matcher(s).replaceAll(replacement);
    }
}

