/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.api;

import com.ibm.ba.glass.api.ContextPart;
import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.ba.glass.defaults.DefaultTheme;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class PerspectiveContextImpl
implements PerspectiveContext {
    private List<String> excludedFeatures = new ArrayList<String>();
    private String loginPerspective = "login";
    private Locale locale = Locale.ENGLISH;
    private String etagHash;
    private String themeName;
    private Map<String, ContextPart> contextParts = new TreeMap<String, ContextPart>();
    private JsonObject extensions;
    @Inject
    private DefaultTheme defaultTheme;

    @PostConstruct
    public void initialize() {
        this.themeName = this.defaultTheme.getID();
    }

    @Override
    public List<String> getExcludedFeatures() {
        return this.excludedFeatures;
    }

    public void setExcludedFeatures(List<String> excludedFeatures) {
        this.excludedFeatures = excludedFeatures;
    }

    @Override
    public String getLoginPerspective() {
        return this.loginPerspective;
    }

    public void setLoginPerspective(String loginPerspective) {
        this.loginPerspective = loginPerspective;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getEtagHash() {
        return this.etagHash;
    }

    public void setEtagHash(String etagHash) {
        this.etagHash = etagHash;
    }

    @Override
    public String getThemeName() {
        return this.themeName;
    }

    @Override
    public JsonObject getExtensions() {
        return this.extensions;
    }

    public void setExtensions(JsonObject extensions) {
        this.extensions = extensions;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    public void addContextPart(ContextPart part) {
        this.contextParts.put(part.getName(), part);
    }

    protected Map<String, ContextPart> getContextParts() {
        return this.contextParts;
    }

    @Override
    public JsonObject getAdditionalContext(String name) {
        ContextPart part = this.getContextParts().get(name);
        return part != null ? part.getValue() : null;
    }

    @Override
    public Object getInnerData(String name) {
        ContextPart part = this.getContextParts().get(name);
        return part != null ? part.getInnerData() : null;
    }

    @Override
    public JsonObject getClientContext() {
        JsonObject clientContext = new JsonObject();
        Collection<ContextPart> parts = this.getContextParts().values();
        for (ContextPart p : parts) {
            if (!p.isClientContext()) continue;
            JsonObject json = p.getValue();
            JsonArray jsonArray = json.getArray("context_part_jsonarray_values");
            clientContext.set(p.getName(), jsonArray != null ? jsonArray : json);
        }
        return clientContext;
    }
}

