/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.api;

import com.ibm.ba.glass.annotations.Managed;
import com.ibm.ba.glass.api.CDNPathResolver;
import com.ibm.ba.glass.api.PerspectiveContext;
import com.ibm.ba.glass.spi.PerspectiveFilter;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class PerspectiveFilterManager {
    private List<PerspectiveFilter> filtersList = new ArrayList<PerspectiveFilter>();
    @Inject
    @Managed
    CDNPathResolver cdnPathResolver;

    @Inject
    void initFilters(Instance<PerspectiveFilter> providers) {
        if (!providers.isUnsatisfied()) {
            for (PerspectiveFilter provider : providers) {
                this.filtersList.add(provider);
            }
        }
        this.filtersList.sort((filterOne, filterTwo) -> {
            if (filterOne.getOrder() == filterTwo.getOrder()) {
                return 0;
            }
            if (filterOne.getOrder() > filterTwo.getOrder()) {
                return 1;
            }
            return -1;
        });
    }

    public void doFilter(JsonObject spec, PerspectiveContext context, Set<String> filterIds) {
        Filterer filterer = filterIds != null ? new Filterer(this.getSubsetOfFiltersList(filterIds)) : new Filterer(this.filtersList);
        filterer.filterOnObject(spec, context);
    }

    public void doFilter(JsonObject spec, PerspectiveContext context) {
        this.doFilter(spec, context, null);
    }

    private List<PerspectiveFilter> getSubsetOfFiltersList(Set<String> filterIds) {
        ArrayList<PerspectiveFilter> filters = new ArrayList<PerspectiveFilter>();
        for (PerspectiveFilter filter : this.filtersList) {
            String filterId = filter.getId();
            if (!filterIds.contains(filterId)) continue;
            filters.add(filter);
        }
        return filters;
    }

    private class Filterer {
        private List<PerspectiveFilter> filtersList;

        public Filterer(List<PerspectiveFilter> filtersList) {
            this.filtersList = filtersList;
        }

        private boolean filterPlugin(JsonObject plugin, PerspectiveContext context) {
            if (plugin != null) {
                for (PerspectiveFilter filter : this.filtersList) {
                    if (filter.doFilter(plugin, context)) continue;
                    return false;
                }
            }
            return true;
        }

        public void filterOnObject(JsonObject json, PerspectiveContext context) {
            Set entrySet = json.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object value = entry.getValue();
                if (value instanceof JsonObject) {
                    JsonObject obj = (JsonObject)value;
                    this.filterOnObject(obj, context);
                    boolean isValid = this.filterPlugin(obj, context);
                    if (isValid) continue;
                    iterator.remove();
                    continue;
                }
                if (value instanceof JsonArray) {
                    this.filterOnArray((JsonArray)value, context);
                    continue;
                }
                if (!(value instanceof String)) continue;
                entry.setValue(this.resolveCdnPath((String)value, context));
            }
        }

        private void filterOnArray(JsonArray json, PerspectiveContext context) {
            for (int i = json.size() - 1; i >= 0; --i) {
                Object value = json.get(i);
                if (value instanceof JsonObject) {
                    JsonObject obj = (JsonObject)value;
                    this.filterOnObject(obj, context);
                    boolean isValid = this.filterPlugin(obj, context);
                    if (isValid) continue;
                    json.remove(i);
                    continue;
                }
                if (value instanceof JsonArray) {
                    this.filterOnArray((JsonArray)value, context);
                    continue;
                }
                if (!(value instanceof String)) continue;
                json.set(i, (Object)this.resolveCdnPath((String)value, context));
            }
        }

        private String resolveCdnPath(String value, PerspectiveContext context) {
            return PerspectiveFilterManager.this.cdnPathResolver.resolve(value, context);
        }
    }
}

