/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.builtin;

import com.ibm.ba.glass.builtin.ThemeDefinition;
import com.ibm.ba.glass.builtin.ThemeModel;
import com.ibm.ba.glass.builtin.ThemeProvider;
import com.ibm.ba.glass.utils.CustomPropertyUtils;
import com.ibm.bi.json.JsonObject;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BuiltInThemeCache {
    private static final String GLASS_THEME_DISABLED = "com.ibm.ba.DisableGlassTheme";
    private static final String GLASS_THEME = "glass";
    private static final Logger LOGGER = LoggerFactory.getLogger(BuiltInThemeCache.class);
    private HashMap<String, ThemeModel> themeModels = new HashMap();
    @Inject
    private ThemeProvider themeProvider;
    @Inject
    @Any
    private Instance<ThemeDefinition> themeDefinitions;

    public void initialize() {
        for (ThemeDefinition themeDefinition : this.themeDefinitions) {
            if (GLASS_THEME.equals(themeDefinition.getID()) && this.isGlassThemeDisabled()) continue;
            this.addThemeModel(themeDefinition);
        }
    }

    private boolean isGlassThemeDisabled() {
        String isDisabled = CustomPropertyUtils.readCustomProperty(GLASS_THEME_DISABLED, "false");
        return Boolean.parseBoolean(isDisabled);
    }

    private void addThemeModel(ThemeDefinition themeDefinition) {
        try {
            String id = themeDefinition.getID();
            String label = themeDefinition.getLabel();
            JsonObject spec = this.themeProvider.getSpec(themeDefinition.getSpecPath());
            String palette = this.themeProvider.getPalette(spec, themeDefinition.getPaletteTemplatePath());
            byte[] favicon = this.themeProvider.getFavicon(themeDefinition.getFaviconPath());
            this.themeModels.put(id, new ThemeModel(id, label, spec, palette, favicon));
        }
        catch (Exception error) {
            LOGGER.error("Error loading '" + themeDefinition.getID() + "' built in theme.", (Throwable)error);
        }
    }

    public ThemeModel getBuiltInThemeModel(String id) {
        return this.themeModels.get(id);
    }

    public ThemeModel[] getBuiltInThemes() {
        return this.themeModels.values().toArray(new ThemeModel[this.themeModels.size()]);
    }
}

