/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.glass.builtin;

import com.ibm.ba.glass.resource.Palette;
import com.ibm.ba.glass.utils.ByteUtils;
import com.ibm.bi.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeProvider.class);
    @Inject
    private ByteUtils byteUtils;

    public JsonObject getSpec(String specPath) {
        try {
            InputStream stream = ThemeProvider.class.getClassLoader().getResourceAsStream(specPath);
            String spec = IOUtils.toString((InputStream)stream);
            stream.close();
            return JsonObject.parseString((String)spec, (boolean)true);
        }
        catch (IOException error) {
            LOGGER.error("Error reading Theme JSON spec", (Throwable)error);
            return null;
        }
    }

    public byte[] getFavicon(String faviconPath) {
        InputStream stream = ThemeProvider.class.getClassLoader().getResourceAsStream(faviconPath);
        return this.byteUtils.getByteArray(stream);
    }

    public String getPalette(JsonObject spec, String paletteTemplate) {
        try {
            Palette palette = new Palette();
            palette.initialize(spec, paletteTemplate);
            return palette.generateCSS();
        }
        catch (Exception error) {
            LOGGER.error("Error generating theme palette CSS file.", (Throwable)error);
            return null;
        }
    }
}

